package com.bcxin.ars.rest.msg;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.UeditorResult;
import com.bcxin.ars.model.msg.SysAttachment;
import com.bcxin.ars.rest.BaseController;
import com.bcxin.ars.service.msg.SysAttachmentService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;

@Controller
@RequestMapping("sysAttachment")
public class SysAttachmentController {

private Logger logger = LoggerFactory.getLogger(BaseController.class);
	
	@Value("${base-folder}")
	private String baseFolder;
	
	@Value("${sysAttachmentFolder}")
	private String sysAttachmentFolder;
	
	@Autowired
	private SysAttachmentService sysAttachmentService;

	@Autowired
	private ConfigUtils configUtils;

    @Value("${upload-folder}")
    private String uploadFolder;

	/**
	 * 上传文件
	 * @param file
	 * @return
	 */
	@RequestMapping("uploadFile")
	public @ResponseBody AjaxResult uploadFile(MultipartFile file) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Date now = new Date();
			String originalFilename = file.getOriginalFilename();
			String uploadFileName = originalFilename.substring(0,originalFilename.lastIndexOf(".")); //文件名
			String materialFileType = originalFilename.substring(originalFilename.lastIndexOf(".")+1); //文件类型
			String fileName = createFileName(materialFileType);
			String dirDate = DateUtil.systemDate.format(now);
			File dir = new File(sysAttachmentFolder + dirDate);
			if(!dir.exists()) {
				dir.mkdirs();
			}
			String key = "sysAttachment/" +dirDate + "/" + fileName;
			String url = "getResource.do?path=" + key;
			String targetPath = sysAttachmentFolder + dirDate + "/" + fileName;
			File targetFile = new File(targetPath);
			logger.info("执行本地文件上传..." + targetFile);
			file.transferTo(targetFile);
			
			SysAttachment sysAttachment = new SysAttachment();
			sysAttachment.setPath(url);
			sysAttachment.setFileName(uploadFileName+"."+materialFileType);
			sysAttachment.setFileSize(file.getSize());
			sysAttachmentService.saveOrUpdate(sysAttachment);
			logger.info("本地文件上传成功!");
			result.setSuccessful(true);
			result.setData(sysAttachment);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
    /**
     * 上传文件(回复)
     * @param file
     * @return
     */
    @RequestMapping("uploadFileReply")
    public @ResponseBody AjaxResult uploadFileReply(MultipartFile file) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Date now = new Date();
			String originalFilename = file.getOriginalFilename();
			String uploadFileName = originalFilename.substring(0,originalFilename.lastIndexOf(".")); //文件名
			String materialFileType = originalFilename.substring(originalFilename.lastIndexOf(".")+1); //文件类型
			String fileName = createFileName(materialFileType);
			String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(uploadFolder + dirDate);
            if(!dir.exists()) {
                dir.mkdirs();
            }
            String key = "upload/" +dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = uploadFolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行本地文件上传..." + targetFile);
            file.transferTo(targetFile);

            SysAttachment sysAttachment = new SysAttachment();
            sysAttachment.setPath(url);
            sysAttachment.setFileName(uploadFileName+"."+materialFileType);
            sysAttachment.setFileSize(file.getSize());
            sysAttachmentService.saveOrUpdate(sysAttachment);
            logger.info("本地文件上传成功!");
            result.setSuccessful(true);
            result.setData(sysAttachment);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
	 * 上传图片
	 *
	 * @return
	 * @throws IOException
	 * @throws IllegalStateException
	 */
	@RequestMapping(value = "ueditorUpload")
	public @ResponseBody UeditorResult ueditorUpload(HttpServletRequest request, HttpServletResponse response) throws IllegalStateException, IOException {
		UeditorResult rui = null;// 这个是UEditor需要的返回值内容，UEditor要的返回值需要封装成Json格式
		// 转型为MultipartHttpRequest：
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		// 获得文件：
		MultipartFile file = multipartRequest.getFile("upfile"); // UEditor传到后台的是这个upfile，其他的文件上传，应该也差不多是这个，还没去研究，断点一下就知道了
		
		Date now = new Date();
		String originalFilename = file.getOriginalFilename();
		String uploadFileName = originalFilename.substring(0,originalFilename.lastIndexOf(".")); //文件名
		String materialFileType = originalFilename.substring(originalFilename.lastIndexOf(".")+1); //文件类型
		String fileName = createFileName(materialFileType);
		String dirDate =  DateUtil.systemDate.format(now);
		File dir = new File(sysAttachmentFolder + dirDate);
		if(!dir.exists()) {
			dir.mkdirs();
		}
		String key = "sysAttachment/" + dirDate + "/" + fileName;
		String url = "getResource.do?path=" + key;
		String targetPath = sysAttachmentFolder + dirDate + "/" + fileName;
		File imageFile = new File(targetPath);
		logger.info("执行本地文件上传..." + imageFile);
		file.transferTo(imageFile);
		
		// 现在获取了File接下来要上传到OSS上
		if (imageFile != null) {

			SysAttachment sysAttachment = new SysAttachment();
			sysAttachment.setPath(url);
			sysAttachment.setFileName(uploadFileName+"."+materialFileType);
			sysAttachment.setFileSize(file.getSize());
			sysAttachment.setBusinesstype(Constants.FILE_BUSINESSTYPE_UEDITOR);
			sysAttachmentService.saveOrUpdate(sysAttachment);
			logger.info("本地文件上传成功!");
			
			
			rui = new UeditorResult();
			rui.setId(sysAttachment.getId().toString());
			rui.setTitle(imageFile.getName());// 这里需要设置文件名称如：xxx.jpg
			rui.setOriginal(imageFile.getName());// 这里需要设置文件名称如：xxx.jpg
			// 上传文件(这里文件类型，要根据实际上传的类型去做，暂时是直接设置了.jpg，并且先保存到磁盘，这样对磁盘比较伤，每次上传都要先保存到磁盘，然后再删除)
			// 判断如果返回结果不为空并且MD5返回值比较结果正确，就设置文件路径保存到数据库
			rui.setState("SUCCESS");// 这里上传成功的话一定要设置大写的// SUCCESS，失败还没测试，猜应该是FAIL，回头再去官网找找
			rui.setUrl(url);
		}
		return rui;
	}
	
	@RequestMapping(value = "delete")
	public @ResponseBody AjaxResult delete(Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			sysAttachmentService.delete(id);
			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

	@RequestMapping("findAllByBusiness")
	public @ResponseBody AjaxResult findAllByBusiness(String businessid) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<SysAttachment> data = sysAttachmentService.findAllByBusiness(businessid,Constants.FILE_BUSINESSTYPE_MSG_POLICE);
			result.setSuccessful(true);
			result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
    /***
     * 根据业务ID和类型获取附件
     * @param businessid
     * @param businessType
     * @return
     * @throws Exception
     */
    @RequestMapping("findAllByBusinessByType")
    public @ResponseBody AjaxResult findAllByBusinessByType(String businessid,String businessType) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<SysAttachment> data = sysAttachmentService.findAllByBusiness(businessid,businessType);
            result.setSuccessful(true);
            result.setData(data);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

	/**
	 * 下载
	 * @param id
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@RequestMapping(value = "/download.do")
	public void downloadAction(Long id, HttpServletRequest request, HttpServletResponse response) throws Exception {
		SysAttachment sysAttachment = sysAttachmentService.findById(id);
		String fileName = sysAttachment.getFileName();
        String path = sysAttachment.getPath();
        if(path.indexOf("sysAttachment")>0) {
            path = sysAttachmentFolder + sysAttachment.getPath().replace("getResource.do?path=sysAttachment/", "");
        } else if(path.indexOf("upload")>0) {
            path = uploadFolder + sysAttachment.getPath().replace("getResource.do?path=upload/", "");
        }
		response.setContentType("application/x-msdownload");
		response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName,"UTF-8"));
		BufferedInputStream br = new BufferedInputStream(new FileInputStream(path));
		byte[] buf = new byte[1024];
		int len = 0;
		OutputStream out = response.getOutputStream();
		while ((len = br.read(buf)) > 0) {
			out.write(buf, 0, len);
		}
		br.close();
		out.close();
	}

	private String createFileName(String materialFileType){
		StringBuffer fileName = new StringBuffer();
		Date now = new Date();
		int rannum =(int) (Math.random()*(99999-10000)+10000);// 获取5位随机数
		return fileName.append(now.getTime()).append(rannum).append(".").append(materialFileType).toString();
	}
}
