package com.bcxin.ars.rest.msg;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.msg.NewsnoticeCompanySearchDto;
import com.bcxin.ars.model.msg.MessageNotice;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.msg.MessageNoticeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@Controller
@RequestMapping("messagenoticecompany")
public class MessageNoticeController {

    private Logger logger = LoggerFactory.getLogger(MessageNoticeController.class);

    @Autowired
    private MessageNoticeService messageNoticeService;

    @Autowired
    private ArsRestUtil arsUtil;

    @RequestMapping("searchAllMessage")
    public @ResponseBody
    AjaxResult searchAllMessage(NewsnoticeCompanySearchDto dto) {

        List<MessageNotice> messageNoticeList = messageNoticeService.findAll();
        AjaxResult result = new AjaxResult();
        try {
            if (messageNoticeList != null&&messageNoticeList.size()>0) {
                result.setSuccessful(true);
                result.setData(messageNoticeList);
            } else {
                result.setSuccessful(false);
                result.setMsg("没有任何消息");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }



}
