package com.bcxin.ars.rest.mobile;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.CompanyPageSearchDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.page.task.ComTaskSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.bcxin.ars.model.sys.Sysarea;
import com.bcxin.ars.rest.sb.PersonGradeController;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.sys.ModuleMenuService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.task.ComTaskService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;

/**
 * @Auther linqinglin
 * @date 2020/2/14 17:37
 */
@RequestMapping("/mobile")
@Controller
public class MobileIndexController {
    private static final Logger logger = LoggerFactory.getLogger(PersonGradeController.class);

    @Autowired
    private ComTaskService comTaskService;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SecurityCompanyService securityCompanyService;
    @Autowired
    private SysareaService sysareaService;

    @Autowired
    private UserService userService;
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private PoliceService policeService;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private LoginLogService loginLogService;
    @Autowired
    private ModuleMenuService moduleMenuService;

    @RequestMapping("/error")
    public ModelAndView error() {
        return new ModelAndView("mobile/error");
    }

    @RequestMapping("/login")
    public ModelAndView login(@RequestParam(value = "userid", required = false) String userid, HttpServletRequest request) {
        ModelAndView view =  new ModelAndView("mobile/login");
        view.addObject("useridIPolice",userid);
        return view;
    }
    @Value("${login-timeout}")
    private int loginTimeout = 10;

    @RequestMapping("/search")
    public ModelAndView search() {
        return new ModelAndView("mobile/search");
    }

    @RequestMapping("/help")
    public ModelAndView help() {
        return new ModelAndView("mobile/help");
    }

    @RequestMapping("/userCenter")
    public ModelAndView userCenter() {
        return new ModelAndView("mobile/userCenter");
    }

    @RequestMapping("/showSign")
    public ModelAndView showSign() {
        return new ModelAndView("mobile/sign");
    }

    @RequestMapping("scene/searchForPage")
    @ResponseBody
    public AjaxResult sceneSearchForPage(String searchType, SearchDto searchDto, AjaxPageResponse page) throws CloneNotSupportedException {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(false);

        User user = arsUtil.getCurrentUser();
        String orgType = user.getPolice().getOrgtype();
        JSONObject resultData = new JSONObject();
        ModuleMenu moduleMenu = null;
        if("task".equals(searchType) || StringUtil.isEmpty(searchType)){
            ComTaskSearchDto taskSearchDto = new ComTaskSearchDto();
            BeanUtils.copyPropertiesIgnore(searchDto,taskSearchDto,true);
            taskSearchDto.setTaskName(searchDto.getKeyword());

            moduleMenu = moduleMenuService.findByUniqueId("taskList");
            if(moduleMenu != null){
                taskSearchDto.setRankAuth(moduleMenu.getRankAuth());
            }

            if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
                if(!Constants.POLICE_ORGTYPE_PCS.equals(orgType)){
                    taskSearchDto.setAreaCode(configUtils.getCurrentNative());
                }
            }
            AjaxPageResponse taskPage = page.clone();
            comTaskService.search(taskSearchDto,taskPage);
            resultData.put("task",taskPage);

            if(taskPage.getTotal()>0){
                result.setSuccessful(true);
            }
        }

        if("person".equals(searchType) || StringUtil.isEmpty(searchType)){
            PersonPageSearchDto personSearchDto = new PersonPageSearchDto();
            BeanUtils.copyPropertiesIgnore(searchDto,personSearchDto,true);
            //personSearchDto.setRealName(searchDto.getKeyword());
            moduleMenu = moduleMenuService.findByUniqueId("securityOfficerList");
            if(moduleMenu != null){
                personSearchDto.setRankAuth(moduleMenu.getRankAuth());
            }
            moduleMenuService.findByUniqueId("personCompany");
            moduleMenuService.findByUniqueId("trainCompany");
            moduleMenuService.findByUniqueId("conCompany");
            AjaxPageResponse personPage = page.clone();
            personSearchDto.setPageNumber(personPage.getPageNumber());
            personSearchDto.setPageSize(personPage.getPageSize());
            securityPersonService.searchForPage(personSearchDto,personPage);
            resultData.put("person",personPage);
            if(personPage.getTotal()>0){
                result.setSuccessful(true);
            }
        }

        if("com0102".equals(searchType) || StringUtil.isEmpty(searchType)){
            CompanyPageSearchDto com0102SearchDto = new CompanyPageSearchDto();
            BeanUtils.copyPropertiesIgnore(searchDto,com0102SearchDto,true);

            moduleMenu = moduleMenuService.findByUniqueId("personCompany");
            if(moduleMenu != null){
                com0102SearchDto.setRankAuth(moduleMenu.getRankAuth());
            }


            com0102SearchDto.setInstitutionType(Constants.BKT_ORGTYPE_GS);
            com0102SearchDto.setName(searchDto.getKeyword());
            AjaxPageResponse com0102Page = page.clone();
            securityCompanyService.searchForPage(com0102SearchDto,com0102Page);
            resultData.put("com0102",com0102Page);
            if(com0102Page.getTotal()>0){
                result.setSuccessful(true);
            }
        }

        if(StringUtil.isEmpty(searchType)){
            CompanyPageSearchDto com0103SearchDto = new CompanyPageSearchDto();
            BeanUtils.copyPropertiesIgnore(searchDto,com0103SearchDto,true);
            moduleMenu = moduleMenuService.findByUniqueId("trainCompany");
            if(moduleMenu != null){
                com0103SearchDto.setRankAuth(moduleMenu.getRankAuth());
            }

            com0103SearchDto.setInstitutionType(Constants.BKT_ORGTYPE_JG);
            com0103SearchDto.setName(searchDto.getKeyword());
            AjaxPageResponse com0103Page = page.clone();
            securityCompanyService.searchForPage(com0103SearchDto,com0103Page);
            resultData.put("com0103",com0103Page);
            if(com0103Page.getTotal()>0){
                result.setSuccessful(true);
            }
        }

        if("com0104".equals(searchType) || StringUtil.isEmpty(searchType)){
            CompanyPageSearchDto com0104SearchDto = new CompanyPageSearchDto();
            BeanUtils.copyPropertiesIgnore(searchDto,com0104SearchDto,true);
            moduleMenu = moduleMenuService.findByUniqueId("conCompany");
            if(moduleMenu != null){
                com0104SearchDto.setRankAuth(moduleMenu.getRankAuth());
            }
            com0104SearchDto.setInstitutionType(Constants.BKT_ORGTYPE_WY);
            com0104SearchDto.setName(searchDto.getKeyword());
            AjaxPageResponse com0104Page = page.clone();
            securityCompanyService.searchForPage(com0104SearchDto,com0104Page);
            resultData.put("com0104",com0104Page);
            if(com0104Page.getTotal()>0){
                result.setSuccessful(true);
            }
        }


        result.setData(resultData);
        return result;

    }
    /**
     * 广西i微警单点登陆
     * @param userid 用户信息
     * @return
     */
    @RequestMapping(value = "singleLoginIPolice")
    public ModelAndView singleLoginIPolice(@RequestParam(value = "userid", required = true) String userid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String page="mobile/login";
        try {
            //登陆信息
            UsernamePasswordToken token = new UsernamePasswordToken(userid, "");
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            //广西内网单点登陆标记
            token.setHost(Constants.GX_NW_Code);
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
            }
            //判断是否登录成功！
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = null;
                //edit subh 2019-03-09  7:43根据用户类型和用户查询用户
                user = userService.findByUsername(userid,Constants.PLATFORM_POLICE+"");
                //内网不允许保安公司登陆 add subh 2018-06-10 end
                //logger.info("当前登录用户是："+user.getUsername());
                //功能权限
                if(user.getPlatform() == Constants.PLATFORM_POLICE  ) {
                    //机构信息
                    Police police = policeService.findById(user.getOrgid());
                    if(police!=null){
                        user.setPolice(police);
                    }
                    /***
                     * 城市区域
                     */
                    String cityAreaCode =police.getAreacode().substring(0,4)+"00";
                    user.setCityAreaCode(cityAreaCode);
                    //获取用户的数据权限机构编码列表 add subh 2019-04-05 10:25
                    user.setAreasList(policeService.findDataPoliceForUserID(user.getId()));
                    //获取城市信息
                    //只要广西
                    if(Constants.GUANGXI.equals(configUtils.getCurrentNative()) && user.getPolice() !=null && !Constants.ORGTYPE_PROVINCE.equals(user.getPolice().getOrgtype())) {
                        Sysarea sysarea = sysareaService.findByCode(cityAreaCode);
                        if(sysarea!=null){
                            //城市名称
                            user.setCityName(sysarea.getName());
                            //城市标识
                            user.setCity(cityAreaCode);
                        }
                    }

                }
                //登录次数+1
                if( null!= user.getLoginNum() ) {
                    user.setLoginNum(user.getLoginNum()+1);
                }else{
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userService.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                arsUtil.setCurrentUser(user,1000*120*loginTimeout);
                loginLogService.logIn(request);
                request.getSession().setAttribute(Constants.LOGIN_USER, user);
                request.getSession().setAttribute(Constants.SESSION_ID, user.getSessionId());
                page = "mobile/search";
            }
        } catch (UnknownAccountException e) {
            logger.info(e.getMessage(), e);
        } catch (IncorrectCredentialsException e) {
            logger.info(e.getMessage(), e);
        } catch (ExcessiveAttemptsException e) {
            logger.error(e.getMessage(), e);
        } catch (AuthenticationException e) {
            logger.error(e.getMessage(), e);
        }catch (ArsException e) {
            logger.error(e.getMessage(), e);
        }
        return new ModelAndView(page);
    }


    /**
     * 检查记录
     * @return
     */
    @RequestMapping("/checkLog")
    public ModelAndView checkLog() {
        ModelAndView view = new ModelAndView("mobile/checkLog");
        return view;
    }
}
