package com.bcxin.ars.rest.mobile;

import com.bcxin.ars.dto.page.task.ComContractSearchDto;
import com.bcxin.ars.service.task.ComContractService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

/**
 * @Auther linqinglin
 * @date 2020/2/20 15:21
 */
@RequestMapping("mobile/contract")
@Controller
public class MobileContractController {


    @Autowired
    private ComContractService comContractService;

    /**
     * 合同列表
     * @param searchDto
     * @return
     */
    @RequestMapping("/list")
    public ModelAndView detail(ComContractSearchDto searchDto) {
        ModelAndView view = new ModelAndView("mobile/contract/list");
        view.addObject("searchDto",searchDto);
        return view;
    }


    /**
     * 合同详情
     * @param id
     * @return
     */
    @RequestMapping("/detail")
    public ModelAndView detail(Long id) {
        ModelAndView view = new ModelAndView("mobile/contract/detail");
        view.addObject("record",comContractService.findDetailById(id));
        return view;
    }
}
