package com.bcxin.ars.rest.mobile;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.OrganizationDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.service.OrganizationService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.supervision.CompanyAwardService;
import com.bcxin.ars.service.supervision.CompanyInspectionService;
import com.bcxin.ars.service.supervision.CompanyPunishService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.xiaoleilu.hutool.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author linqinglin
 * @date 2020/02/18 0018 13:07
 */
@RequestMapping("mobile/company")
@Controller
public class MobileCompanyController {


    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private OrganizationService organizationService;

    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private CompanyAwardService companyAwardService;

    @Autowired
    private CompanyPunishService companyPunishService;

    @Autowired
    private CompanyInspectionService companyInspectionService;

    @Autowired
    private ConfigUtils configUtils;

    @RequestMapping("/list")
    public ModelAndView detail(String type,String typeName,String name) {
        ModelAndView view = new ModelAndView("mobile/company/list");
        view.addObject("type",type);
        view.addObject("typeName",typeName);
        view.addObject("name",name);
        return view;
    }

    /**
     * 企业概述
     * @param id
     * @return
     */
    @RequestMapping("/detail")
    public ModelAndView detail(Long id) {
        ModelAndView view = new ModelAndView("mobile/company/detail");
        view.addObject("record",securityCompanyService.findById(id));
        return view;
    }

    /**
     * 基础信息
     * @param id
     * @return
     */
    @RequestMapping("/baseInfo")
    public ModelAndView baseInfo(Long id) {
        ModelAndView view = new ModelAndView("mobile/company/baseInfo");
        view.addObject("record",securityCompanyService.findById(id));
        return view;
    }

    /**
     * 部门架构
     * @param company 公司
     * @return
     */
    @RequestMapping("/depart")
    public ModelAndView depart(SecurityCompany company) {
        ModelAndView view = new ModelAndView("mobile/company/depart");
        view.addObject("company",company);
        return view;
    }

    @RequestMapping("/depart/list")
    @ResponseBody
    public AjaxResult departList(OrganizationDto orgDto){
        AjaxResult result = new AjaxResult();
        result.setSuccessful(false);
        SecurityCompany company = securityCompanyService.findById(orgDto.getCompanyId());
        List<OrganizationDto> orgList = organizationService.findByParentIdAndCompanyId(orgDto);
        if(orgDto.getParentId() == null){
            if(orgList != null && orgList.size() > 0) {
                for (OrganizationDto org : orgList) {
                    if(org.getOrgName().equals("无部门人员")){
                        orgDto = org;
                        orgDto.setOrgName(company.getName());
                        orgDto.setPersonList(securityPersonService.findByOrgId(orgDto.getId()));
                    }
                }
            }
            orgList.remove(orgDto);
        }else{
            orgDto.setPersonList(securityPersonService.findByOrgId(orgDto.getParentId()));
        }

        orgDto.setChildrens(orgList);
        result.setData(orgDto);
        result.setSuccessful(true);
        return result;
    }

    private void setChildrens(OrganizationDto org,List<OrganizationDto> orgList){
        List<OrganizationDto> childrens = orgList.stream().filter((orgDto)-> ObjectUtil.equal(org.getId(),orgDto.getParentId())).collect(Collectors.toList());
        if(childrens != null && childrens.size() > 0){
            for (OrganizationDto children : childrens) {
                setChildrens(children,orgList);
            }
            org.setChildrens(childrens);
        }
    }

    /**
     * 检查记录
     * @return
     * @param company 公司
     */
    @RequestMapping("/checkLog")
    public ModelAndView checkLog(SecurityCompany company) {
        ModelAndView view = new ModelAndView("mobile/company/checkLog");
        view.addObject("record",company);
        return view;
    }

    /**
     * 新增表彰奖励
     * @param company
     * @return
     */
    @RequestMapping("/award")
    public ModelAndView award(SecurityCompany company) {
        ModelAndView view = new ModelAndView("mobile/company/award");
        view.addObject("record",company);
        view.addObject("token", configUtils.getToken());
        return view;
    }

    /**
     * 表彰奖励详情
     * @param id
     * @return
     */
    @RequestMapping("/award/detail")
    public ModelAndView awardDetail(Long id,String routeType) {
        ModelAndView view = new ModelAndView("mobile/company/awardDetail");
        view.addObject("record",companyAwardService.findById(id));
        view.addObject("routeType",routeType);
        return view;
    }

    /**
     * 新增违法违规处罚
     * @param company
     * @return
     */
    @RequestMapping("/punish")
    public ModelAndView punish(SecurityCompany company) {
        ModelAndView view = new ModelAndView("mobile/company/punish");
        view.addObject("record",company);
        view.addObject("token", configUtils.getToken());
        return view;
    }

    /**
     * 违法违规处罚详情
     * @param id
     * @return
     */
    @RequestMapping("/punish/detail")
    public ModelAndView punishDetail(Long id,String routeType) {
        ModelAndView view = new ModelAndView("mobile/company/punishDetail");
        view.addObject("record",companyPunishService.findById(id));
        view.addObject("routeType",routeType);
        return view;
    }


    /**
     * 新增监督检查
     * @param company
     * @return
     */
    @RequestMapping("/inspection")
    public ModelAndView inspection(SecurityCompany company) {
        ModelAndView view = new ModelAndView("mobile/company/inspection");
        view.addObject("record",company);
        view.addObject("token", configUtils.getToken());
        return view;
    }
    /**
     * 监督检查详情
     * @param id
     * @return
     */
    @RequestMapping("/inspection/detail")
    public ModelAndView inspectionDetail(Long id,String routeType) {
        ModelAndView view = new ModelAndView("mobile/company/inspectionDetail");
        view.addObject("record",companyInspectionService.findById(id));
        view.addObject("routeType",routeType);
        return view;
    }
}
