package com.bcxin.ars.rest.jit;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.Sysarea;
import com.bcxin.ars.rest.UserController;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DES3;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.rest.util.JitGatewayUtil;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Controller
public class CinasController {

    /***
     * 日志
     */
    private final static Logger logger = LoggerFactory.getLogger(UserController.class);

    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private UserService userService;

    @Autowired
    private ArsRestUtil arsUtil;

    @Autowired
    private PoliceService policeService;

    @Autowired
    private LoginLogService loginLogService;

    @Value("${login-timeout}")
    private int loginTimeout = 10;


    @Value("${authURL}")
    public String authURL;
    @Value("${appId}")
    public String appId;
    @Value("${randomFrom}")
    public String randomFrom;
    @Value("${accessControl}")
    public String accessControl;
    @Value("${QRCodeAuth}")
    public String qRCodeAuth;
    @Value("${generateQRCodeURL}")
    public String generateQRCodeURL;
    @Value("${queryQRCodeStateURL}")
    public String queryQRCodeStateURL;

    @Autowired
    ConfigUtils configUtils;

    /***
     * 生成原文
     * @param
     * @return
     */
    @RequestMapping("/jitGWRandom")
    @ResponseBody
    public AjaxResult random(String username) {
        System.out.println("username"+username.equals("bbd_manager"));
        System.out.println("isIntranet"+!configUtils.isIntranet());
        if (username.equals("bbd_manager") || !configUtils.isIntranet()){
            return new AjaxResult(true, "成功", "login");
        }
        JitGatewayUtil jitGatewayUtil = new JitGatewayUtil();
        JitGatewayUtil.initConfigBean();
        Object qrCodeAuthObj = qRCodeAuth;
        String qrCodeAuthStr = String.valueOf(qrCodeAuthObj);
        String randNum = null;
        if ("false".equals(qrCodeAuthStr)) {
            System.out.println("生成原文开始");
            randNum = jitGatewayUtil.generateRandomNum(randomFrom);
            if (!jitGatewayUtil.isNotNull(randNum)) {
                System.out.println("生成原文为空！");
                return new AjaxResult(false, "获取原文失败");
            }
            System.out.println("生成原文结束，成功生成原文：" + randNum);
        }
        Map data = new HashMap();
        data.put("original_data", randNum);
        data.put("QRCodeAuth", qrCodeAuthStr);
        data.put("original", randNum);
        return new AjaxResult(true, "成功", data);
    }

    @RequestMapping("/jitGWAuth")
    @ResponseBody
    public AjaxResult authen(String authMode, String original, String signed_data, HttpServletRequest request) throws IOException {
        System.out.println("身份认证开始！\n" + authMode);
        JitGatewayUtil jitGatewayUtil = new JitGatewayUtil();
        jitGatewayUtil.jitGatewayUtilBean.setAuthMode("cert");
        jitGatewayUtil.jitGatewayUtilBean.setToken("");
        jitGatewayUtil.jitGatewayUtilBean.setOriginal_data(original);
        jitGatewayUtil.jitGatewayUtilBean.setOriginal_jsp(original);
        jitGatewayUtil.jitGatewayUtilBean.setSigned_data(signed_data);
        jitGatewayUtil.jitGatewayUtilBean.setRemoteAddr("");
        jitGatewayUtil.auth();
        if (!jitGatewayUtil.authResult.isSuccess()) {
            System.out.println("身份认证失败，失败原因：" + jitGatewayUtil.authResult.getErrDesc());
            return new AjaxResult(false, "身份认证失败，失败原因：" + jitGatewayUtil.authResult.getErrDesc());
        } else {

            System.out.println("身份认证成功，认证信息正常返回！\n");
            return new AjaxResult(true, "身份认证成功。");
        }
    }

    private AjaxResult weblogin(User user,HttpServletRequest request){
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(),"");
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            //平台角色
            token.setHost("SN_NW_KPI");
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
                return result;
            }
            //判断是否登录成功！
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                //功能权限
                    //机构信息
                    Police police = policeService.findById(user.getOrgid());
                    if(police!=null){
                        user.setPolice(police);
                    }
                    //设置数据大屏链接
                    userService.setDateView(user);
                    /***
                     * 城市区域
                     */
                    String cityAreaCode =police.getAreacode().substring(0,4)+"00";
                    user.setCityAreaCode(cityAreaCode);
                    //获取用户的数据权限机构编码列表 add subh 2019-04-05 10:25
                    user.setAreasList(policeService.findDataPoliceForUserID(user.getId()));
                    //获取城市信息
                //登录次数+1
                if( null!= user.getLoginNum() ) {
                    user.setLoginNum(user.getLoginNum()+1);
                }else{
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userService.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                arsUtil.setCurrentUser(user,1000*120*loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
            }else{
                result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
            }
        } catch (UnknownAccountException e) {
            //logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (IncorrectCredentialsException e) {
            //logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (ExcessiveAttemptsException e) {
            //logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (AuthenticationException e) {
            //logger.error(e.getMessage(), e);
            //throw e;
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        }catch (ArsException e) {
            //logger.error(e.getMessage(), e);
            //throw e;
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    @RequestMapping("/test")
    @ResponseBody
    public void authenFinished() throws ServletException, IOException {
        System.out.println("authURL:" + authURL);
        System.out.println("appId:" + appId);
        System.out.println("randomFrom:" + randomFrom);
        System.out.println("accessControl:" + accessControl);
        System.out.println("QRCodeAuth:" + qRCodeAuth);
        System.out.println("generateQRCodeURL:" + generateQRCodeURL);
        System.out.println("queryQRCodeStateURL:" + queryQRCodeStateURL);
    }

}
