package com.bcxin.ars.rest.gxhlwWeb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.service.gxhlwWeb.GxhlwWebService;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Controller
@RequestMapping("gxhlwWeb")
public class GxhlwWebController {

    private static final Logger logger = LoggerFactory.getLogger(GxhlwWebController.class);

    @Autowired
    private GxhlwWebService GxhlwWebService;



    /**
     * @Author: wangcy
     * @Description:根据用户名和密码获取用户信息
     * @Date: 2018/03/22 0022 13:39
     */
    @RequestMapping("login")
    public String searchForMap(String sbusno, String username, String pwd, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext servletContext = request.getServletContext();
        String rootPath = servletContext.getContextPath();
        try {
            //登录成功
            if (StringUtil.isNotEmpty(username) && StringUtil.isNotEmpty(pwd)) {
                AjaxResult ajaxResult = GxhlwWebService.verifySX(username, pwd, request);
                if (ajaxResult.isSuccessful()) {
                    return "redirect:/index.do";
                }else{
                    response.sendRedirect(rootPath+"/login.jsp");
                }
            } else {
                response.sendRedirect(rootPath+"/login.jsp");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return "gxhlwWebDto/error";
    }

    /**
     * @Author: wangcy
     * @Description:根据用户名和密码获取用户信息
     * @Date: 2018/03/22 0022 13:39
     */
    @RequestMapping("loginNW")
    public String loginNW(String username, String key,HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext servletContext = request.getServletContext();
        String rootPath = servletContext.getContextPath();
        try {
            //登录成功
            if (StringUtil.isNotEmpty(username) && StringUtil.isNotEmpty(key)) {
                AjaxResult ajaxResult = GxhlwWebService.verifyGXNW(username, key,request);
                if (ajaxResult.isSuccessful()) {
                    return "redirect:/index.do";
                }else{
                    response.sendRedirect(rootPath+"/login.jsp");
                }
            } else {
                response.sendRedirect(rootPath+"/login.jsp");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return "gxhlwWebDto/error";
    }


}
