package com.bcxin.ars.rest.gx;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.singleLogin.SingleUserDTO;
import com.bcxin.ars.service.gx.DataViewService;
import com.bcxin.ars.util.NNRESTFulConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
/***
 * 南宁获取数据
 */
@Controller
@RequestMapping("dataView")
public class DataViewController {
    @Autowired
    private DataViewService dataViewService;

    /***
     * 查询南宁市数据信息
     * @param dto 用户信息
     * @return
     */
    @RequestMapping("query")
    public @ResponseBody
    AjaxResult searchAllMessage(SingleUserDTO dto) {
        //返回对象
        AjaxResult result = new AjaxResult();
        try {
            //获取数据集
            result.setData( dataViewService.query(dto));
            //返回成功200编码
            result.setCode(NNRESTFulConstants.CODE_SUCCESS);
        } catch (Exception e) {
            //返回成功400编码
            result.setCode(NNRESTFulConstants.CODE_ERROR);
        }
        return result;
    }
}
