package com.bcxin.ars.rest.gen;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.GenTablePageSearchDto;
import com.bcxin.ars.model.gen.GenTable;
import com.bcxin.ars.service.gen.GenTableService;
import com.bcxin.ars.util.text.Convert;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;


/**
 * 代码生成业务表控制器
 *
 * @author linqinglin
 * @Date 2020-08-09 08:11:23
 */
@Controller
@RequestMapping("genTable")
public class GenTableController {

    Logger logger = LoggerFactory.getLogger(GenTableController.class);

    @Autowired
    GenTableService genTableService;

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(GenTablePageSearchDto searchDto){
        ModelAndView view = new ModelAndView("gen/genTable/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 查看页面
     * @param genTable
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(GenTable genTable){
        ModelAndView view = new ModelAndView("gen/genTable/detail");

        if(genTable.getId() != null){
            view.addObject("record",genTableService.findById(genTable.getId()));
        }else {
            view.addObject("record", genTable);
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param genTable
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(GenTable genTable){
        ModelAndView view = new ModelAndView("gen/genTable/edit");

        if(genTable.getId() != null){
            view.addObject("record",genTableService.findById(genTable.getId()));
        }else {
            view.addObject("record", genTable);
        }

        return view;
    }

    /**
     * 保存
     * @param tableId
     * @return
     */
    @RequestMapping("preview/index")
    @ResponseBody
    public AjaxResult preview(Long tableId){
        AjaxResult result = new AjaxResult();
        try {
            Map<String, String> dataMap = genTableService.previewCode(tableId);
            result.setData(dataMap);
            result.setSuccessful(true);
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 保存
     * @param genTable
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(GenTable genTable){
        AjaxResult result = new AjaxResult();
        try {
            genTableService.save(genTable);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(GenTablePageSearchDto dto, AjaxPageResponse<GenTable> page){
        genTableService.searchForPage(dto,page);
        return page;
    }


    /**
     * 导入表结构
     */
    @RequestMapping("/importTable")
    public ModelAndView importTable(GenTablePageSearchDto searchDto){
        ModelAndView view = new ModelAndView("gen/importTable");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 导入表结构（保存）
     */
    @RequestMapping("/importTable/save")
    @ResponseBody
    public AjaxResult importTableSave(String tables){
        AjaxResult result = new AjaxResult();
        String[] tableNames = Convert.toStrArray(tables);
        // 查询表信息
        List<GenTable> tableList = genTableService.selectDbTableListByNames(tableNames);
        genTableService.importGenTable(tableList);
        result.setSuccessful(true);
        return result;
    }

    /**
     * 查询数据库列表
     */
    @RequestMapping("/db/list")
    @ResponseBody
    public AjaxPageResponse dataList(GenTable genTable, AjaxPageResponse<GenTable> page){
        page.setPagination(false);
        genTableService.selectDbTableList(genTable,page);
        return page;
    }


    /**
     * 删除
     */
    @RequestMapping("/delete")
    @ResponseBody
    public AjaxResult delete(GenTable genTable) throws IOException {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        genTableService.delete(genTable);
        return result;
    }

    /**
     * 生成代码（下载方式）
     */
    @RequestMapping("/download/{tableName}")
    public void download(HttpServletResponse response, @PathVariable("tableName") String tableName) throws IOException{
        byte[] data = genTableService.downloadCode(tableName);
        genCode(response, data);
    }

    /**
     * 批量生成代码
     */
    @RequestMapping("/batchGenCode")
    @ResponseBody
    public void batchGenCode(HttpServletResponse response, String tables) throws IOException{
        String[] tableNames = Convert.toStrArray(tables);
        byte[] data = genTableService.downloadCode(tableNames);
        genCode(response, data);
    }

    /**
     * 生成zip文件
     */
    private void genCode(HttpServletResponse response, byte[] data) throws IOException{
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"genlin.zip\"");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write(data, response.getOutputStream());
    }
}

