package com.bcxin.ars.rest.gen;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.gen.GenTable;
import com.bcxin.ars.model.gen.GenTableColumn;
import com.bcxin.ars.service.gen.GenTableColumnService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 代码生成业务表字段控制器
 *
 * @author linqinglin
 * @Date 2020-08-09 08:12:10
 */
@Controller
@RequestMapping("genTableColumn")
public class GenTableColumnController {

    Logger logger = LoggerFactory.getLogger(GenTableColumnController.class);

    @Autowired
    GenTableColumnService genTableColumnService;

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(Long tableId){
        ModelAndView view = new ModelAndView("gen/genTableColumn/list");
        view.addObject("tableId", tableId);
        return view;
    }

    /**
     * 查看页面
     * @param genTableColumn
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(GenTableColumn genTableColumn){
        ModelAndView view = new ModelAndView("gen/genTableColumn/detail");

        if(genTableColumn.getId() != null){
            view.addObject("record",genTableColumnService.findById(genTableColumn.getId()));
        }else {
            view.addObject("record", genTableColumn);
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param genTableColumn
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(GenTableColumn genTableColumn){
        ModelAndView view = new ModelAndView("gen/genTableColumn/edit");

        if(genTableColumn.getId() != null){
            view.addObject("record",genTableColumnService.findById(genTableColumn.getId()));
        }else {
            view.addObject("record", genTableColumn);
        }

        return view;
    }

    /**
     * 保存
     * @param genTableColumn
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(GenTableColumn genTableColumn){
        AjaxResult result = new AjaxResult();
        try {
            genTableColumnService.save(genTableColumn);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 查询数据表字段列表
     */
    @RequestMapping("/search")
    @ResponseBody
    public AjaxPageResponse search(GenTableColumn genTableColumn, AjaxPageResponse<GenTableColumn> page){
        genTableColumnService.search(genTableColumn,page);
        return page;
    }
}

