package com.bcxin.ars.rest.exam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.exam.TrainExamPaper;
import com.bcxin.ars.service.exam.TrainExamPaperService;
import com.bcxin.ars.service.util.ArsUtil;

/**
 * 考试试卷管理
 *
 * @author zhangye
 * @version 1.0
 */
@Controller
@RequestMapping("exam/paper")
public class TrainExamPaperController {

	@Autowired
	private TrainExamPaperService trainExamPaperService;
	@Autowired
	private ArsUtil arsUtil;

	/**
	 * 列表查询
	 *
	 * @param trainExamPaper
	 * @return
	 */
	@RequestMapping(value = "/list")
	@ResponseBody
	public AjaxResult list(TrainExamPaper trainExamPaper) {
		AjaxResult result = new AjaxResult();
		User user = arsUtil.getCurrentUser();
		if (user != null) {
			result.setData(trainExamPaperService.list(trainExamPaper));
			result.setSuccessful(true);
			return result;
		} else {
			return null;
		}
	}
}
