package com.bcxin.ars.rest.exam;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.exam.TrainExamInfoDto;
import com.bcxin.ars.dto.exam.TrainExamInfoSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.exam.TrainExamInfoService;
import com.bcxin.ars.service.util.ArsUtil;

import cn.jiguang.common.utils.StringUtils;

/**
 * 考试信息管理
 * 
 * @author zhangye
 * @version 1.0
 */
@Controller
@RequestMapping("exam/info")
public class TrainExamInfoWebController {

	private static final Logger logger = LoggerFactory.getLogger(TrainExamInfoWebController.class);

	@Autowired
	private TrainExamInfoService trainExamInfoService;
	@Autowired
	private ArsUtil arsUtil;

	/**
	 * 分页查询
	 * 
	 * @param trainExamInfoSearchDto
	 * @return
	 */
	@RequestMapping(value = "/page")
	@ResponseBody
	public PageResult page(TrainExamInfoSearchDto trainExamInfoSearchDto) {
		User user = arsUtil.getCurrentUser();
		if (user != null) {
			if (StringUtils.isNotEmpty(user.getCityAreaCode())) {
				trainExamInfoSearchDto.setAreaCode(user.getCityAreaCode());
			}
			return trainExamInfoService.query(trainExamInfoSearchDto);
		} else {
			return null;
		}
	}

	/**
	 * 新增考试信息
	 * 
	 * @param trainExamInfoDto
	 * @return
	 */
	@RequestMapping(value = "/save")
	@ResponseBody
	public AjaxResult save(TrainExamInfoDto trainExamInfoDto) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				trainExamInfoService.save(trainExamInfoDto, user);
				result.setData(trainExamInfoDto);
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 修改考试信息
	 * 
	 * @param trainExamInfoDto
	 * @return
	 */
	@RequestMapping(value = "/update")
	@ResponseBody
	public AjaxResult update(TrainExamInfoDto trainExamInfoDto) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				trainExamInfoDto = trainExamInfoService.update(trainExamInfoDto, user);
				result.setData(trainExamInfoDto);
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 取消考试信息
	 * 
	 * @param trainExamInfoDto
	 * @return
	 */
	@RequestMapping(value = "/cancel")
	@ResponseBody
	public AjaxResult cancel(TrainExamInfoDto trainExamInfoDto) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				trainExamInfoService.cancel(trainExamInfoDto, user);
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 获取考试信息
	 * 
	 * @param trainExamInfoDto
	 * @return
	 */
	@RequestMapping(value = "/get")
	@ResponseBody
	public AjaxResult get(TrainExamInfoDto trainExamInfoDto) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				result.setData(trainExamInfoService.selectByPrimaryKey(trainExamInfoDto.getId()));
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
