package com.bcxin.ars.rest.conference;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.conference.ConferenceMemberSearchDto;
import com.bcxin.ars.service.conference.ConferenceMemberService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author linqinglin
 * @date 2019/12/18 0018 10:23
 */
@RequestMapping("conference/member")
@Controller
public class ConferenceMemberController {

    private static final Logger logger = LoggerFactory.getLogger(ConferenceMemberController.class);


    @Autowired
    private ConferenceMemberService conferenceMemberService;
    /***
     * 分页查询
     * @param searchDto 查询参数
     * @param page 返回查询列表
     * @throws Exception 异常
     */
    @RequestMapping("searchForPage")
    public @ResponseBody
    AjaxPageResponse searchForPage(ConferenceMemberSearchDto searchDto, AjaxPageResponse page) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            conferenceMemberService.searchForPage(searchDto,page);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return page;
    }
}
