package com.bcxin.ars.rest.conference;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.conference.*;
import com.bcxin.ars.model.conference.CloudConference;
import com.bcxin.ars.service.conference.CloudConferenceService;
import com.bcxin.ars.service.conference.ConferenceAccountService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.HuaweiMeetUtil;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;

/***
 * 会议控制层
 */
@Controller
@RequestMapping("conference")
public class ConferenceController {
    /***
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(ConferenceController.class);

    @Autowired
    private CloudConferenceService cloudConferenceService;

    @Autowired
    private ConferenceAccountService conferenceAccountService;

    @Autowired
    private ArsUtil arsUtil;

    /***
     * 进入查询页面
     * @return 页面路径
     */
    @RequestMapping("/list/page")
    public ModelAndView listPage(HttpServletRequest request) {
        ModelAndView view = new ModelAndView("conference/list");
        return view;
    }

    /**
     * 进入录播文件
     * @return
     * @throws Exception
     */
    @RequestMapping("/toRecordList")
    public ModelAndView toRecordList()  throws Exception  {
       /* //获取录播资源
        AjaxResult ajaxResult = huaweiMeetUtil.callInterfaceV1Resourse(Constants.METHOD_GET, HuaweiMeetConst.RESOURSE_V1);*/
        //开始时间和结束时间的默认值，默认查询一个月时间
        ModelAndView view = new ModelAndView("conference/recordList");
        RecordDto recordDto =  new RecordDto();
        //当前时间减一个月
        recordDto.setStartDate(DateUtil.dateAdd(DateUtil.DATATYPE_MONTH, new Date(), -1));
        //设置当前时间
        recordDto.setEndDate(new Date());
        view.addObject("record",recordDto);
        /*view.addObject("resource",ajaxResult.getData());*/
        return view;
    }



    /***
     * 分页查询
     * @param searchDto 查询参数
     * @param page 返回查询列表
     * @throws Exception 异常
     */
    @RequestMapping("searchForPage")
    public @ResponseBody
    AjaxPageResponse searchForPage(ConferenceSearchDto searchDto, AjaxPageResponse page) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            cloudConferenceService.searchForPage(searchDto,page);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return page;
    }
    @Autowired
    private HuaweiMeetUtil huaweiMeetUtil;
    /***
     * 创建会议
     * @return 页面路径
     */
    @RequestMapping("/edit/page")
    public ModelAndView editPage() {
        //获取会议ID列表
        QueryUserResultDTO conferenceUserDto =  huaweiMeetUtil.getConferenceUserInfo();
        ModelAndView view = new ModelAndView("conference/edit");
        view.addObject("vmrList",conferenceUserDto.getVmrList());
        return view;
    }

    /***
     * 创建会议
     * @return 页面路径
     */
    @RequestMapping("/join/page")
    public ModelAndView joinPage() {
        ModelAndView view = new ModelAndView("conference/joinConference");
        return view;
    }
    /**
     * 查询录播会议文件列表
     */
    @RequestMapping("queryRecordList")
    public @ResponseBody AjaxPageResponse queryRecordList(RecordDto recordDto, AjaxPageResponse page) throws Exception{
        try {
            cloudConferenceService.queryRecordList(recordDto,page);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return page;
    }

    /**
     * 批量删除录播文件
     * @param confUUIDs
     * @return
     * @throws Exception
     */
    @RequestMapping("batchDeleteRecord")
    public @ResponseBody AjaxResult batchDeleteRecord(String[] confUUIDs) throws Exception{
        AjaxResult result = cloudConferenceService.batchDeleteRecord(confUUIDs);
        return result;
    }


    /**
     * 保存会议
     * @return
     */
    @RequestMapping("save")
    public @ResponseBody AjaxResult save(CloudConference conference) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            //返回会议信息用于加入
            result.setData(cloudConferenceService.save(conference));
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 结束会议
     * @return
     */
    @RequestMapping("end/{meetId}")
    public @ResponseBody AjaxResult end(@PathVariable String meetId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            cloudConferenceService.end(meetId);
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 更新会议ConfUUID信息
     * @return
     */
    @RequestMapping("getConfUUID/{meetId}")
    public @ResponseBody AjaxResult getConfUUID(@PathVariable String meetId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            cloudConferenceService.getConfUUID(meetId);
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 会议详情
     * @return 页面路径
     */
    @RequestMapping("/view/page")
    public ModelAndView viewPage(Long id) {
        ModelAndView view = new ModelAndView("conference/detail");
        view.addObject("conference",cloudConferenceService.findById(id));
        return view;
    }

    @RequestMapping("/choicePoliceAccount/page")
    public ModelAndView choicePoliceAccountPage() {
        ModelAndView view = new ModelAndView("conference/choicePoliceAccount");
        return view;
    }
    /****
     * 获取公安会议账号列表
     * @return
     * @throws Exception
     */
    @RequestMapping("getPoliceAccountTree")
    public @ResponseBody
    AjaxResult getPoliceAccountTree(PoliceAccountSearchDto searchDto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            searchDto.setUserId(arsUtil.getCurrentUser().getId());
            result.setSuccessful(true);
            result.setData(conferenceAccountService.getPoliceAccountTree(searchDto));
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    @RequestMapping("/choiceComAccount/page")
    public ModelAndView choiceComAccountPage() {
        ModelAndView view = new ModelAndView("conference/choiceComUser");
        return view;
    }

    /****
     * 获取公司会议账号列表
     * @return
     * @throws Exception
     */
    @RequestMapping("getComAccountTree")
    public @ResponseBody
    AjaxResult getComAccountTree() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(conferenceAccountService.getcomList());
        } catch (Exception e) {
            throw e;
        }
        return result;
    }
    /****
     * 获取公司会议账号列表
     * @return
     * @throws Exception
     */
    @RequestMapping("getPersonAccountTree/{comId}")
    public @ResponseBody
    AjaxResult getPersonAccountTree(@PathVariable String comId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(conferenceAccountService.getPersonAccountList(comId));
        } catch (Exception e) {
            throw e;
        }
        return result;
    }
    /****
     * 分页查询公司会议账号列表
     * @return
     * @throws Exception
     */
    @RequestMapping("getComUserForPage")
    public @ResponseBody
    Object getComUserForPage(PoliceAccountSearchDto searchDto, AjaxPageResponse<MeetComDto> page) throws Exception {
        return conferenceAccountService.searchForPage(searchDto,page);
    }

    @RequestMapping("saveAccountMembers")
    public @ResponseBody
    AjaxResult getPersonAccountTree(CloudConference conference) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            cloudConferenceService.saveAccountMembers(conference);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    @RequestMapping("saveCloudecReleaseChairman")
    public @ResponseBody
    AjaxResult saveCloudecReleaseChairman(CloudConference conference) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            //释放主席
            cloudConferenceService.saveCloudecReleaseChairman(conference);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }
}
