package com.bcxin.ars.rest.certificate;


import com.bcxin.ars.model.certificate.ComCertificateSnapshot;
import com.bcxin.ars.model.certificate.TrainCertificateSnapshot;
import com.bcxin.ars.service.certificate.ComCertificateSnapshotService;
import com.bcxin.ars.service.certificate.TrainCertificateSnapshotService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.CerUtil;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;


/**
 * 培训单位快照保存表
 *
 * @author yyx
 * @Date 2020-04-24 16:23:31
 */
@Controller
@RequestMapping("mobile/trainCertificateSnapshot")
public class TrainCertificateSnapshotController {

    Logger logger = LoggerFactory.getLogger(TrainCertificateSnapshotController.class);

    @Autowired
    private TrainCertificateSnapshotService trainCertificateSnapshotService;

    @Autowired
    private ConfigUtils configUtils;

    /**
     * 培训单位许可证扫描二维码查看页面
     * @param qrCodeId
     * @param type
     * @return
     */
    @RequestMapping("findByQrCodeId/{qrCodeId}")
    public ModelAndView trainFindByQrCodeId(@PathVariable Long qrCodeId,String type) {
        ModelAndView view =  new ModelAndView();
        //根据二维码id查询信息
        TrainCertificateSnapshot trainCertificateSnapshot = trainCertificateSnapshotService.findByQrCodeId(qrCodeId);

        try {
            //许可证号
            String zkzh = configUtils.getValueByKey(Constants.CURRENT_NATIVE_SHORT);
            zkzh = zkzh + "公保服";
            trainCertificateSnapshot.setXkzh(trainCertificateSnapshot.getXkzh().replace(zkzh,""));
            //注册资本的转换
            if(trainCertificateSnapshot.getZczb()!=null) {
                trainCertificateSnapshot.setZczb(CerUtil.digitUppercase(Double.parseDouble(trainCertificateSnapshot.getZczb())));
            }
        }catch (Exception e){
            logger.error("培训单位许可证注册奖金转换失败");
        }
        //正本页面
        if(Constants.CERPRINTTYPE_Z.equals(type)) {
            view.setViewName("mobile/certificate/train");
        }else{
            //副本页面
            view.setViewName("mobile/certificate/trainCopy");
        }
        view.addObject("record",trainCertificateSnapshot);
        return view;
    }
}

