package com.bcxin.ars.rest.certificate;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.certificate.GradeCertificateSearchDto;
import com.bcxin.ars.dto.certificate.ReplaceCompanyCertificateSearchDTO;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.ReplaceCompanyCertificate;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.certificate.ReplaceCompanyCertificateService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/***
 * 换证管理
 */
@Controller
@RequestMapping("replaceCertificate")
public class ReplaceCertificateController {
    /***
     * 日志
     */
    private static  final Logger logger = LoggerFactory.getLogger(ReplaceCertificateController.class);
    @Autowired
    private ArsUtil arsUtil;
    /***
     * 服务层
     */
    @Autowired
    private ReplaceCompanyCertificateService replaceCompanyCertificateService;

    @Autowired
    private SecurityCompanyService companyService;
    /***
     * 进入换证管理查询页面
     */
    @RequestMapping("toQueryPage")
    @RequiresPermissions("replaceCertificate:query")
    public ModelAndView toQueryForTrainOrg(){
        ModelAndView view = new ModelAndView();
        view.setViewName("certificate/replaceCertificate/query");
        return view;
    }

    /***
     * 修改换证信息
     */
    @RequestMapping("edit")
    @RequiresPermissions("replaceCertificate:edit")
    @ResponseBody
    public AjaxResult edit(ReplaceCompanyCertificate replaceCompanyCertificate){
        AjaxResult result = new AjaxResult();
        try {
            replaceCompanyCertificateService.update(replaceCompanyCertificate);
            result.setSuccessful(true);
            result.setMsg("修改成功！");
            return result;
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    /***
     * 根据ID查询信息
     */
    @RequestMapping("find/{id}")
    @RequiresPermissions("replaceCertificate:query")
    @ResponseBody
    public AjaxResult find(@PathVariable Long id){
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(replaceCompanyCertificateService.findById(id));
            return result;
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
    }
    /***
     * 进入换证新增页面
     */
    @RequestMapping("toAddPage")
    @RequiresPermissions("replaceCertificate:add")
    public ModelAndView toAddPage(){
        ModelAndView view = new ModelAndView();
        view.setViewName("certificate/replaceCertificate/add");
        view.addObject("companyList", companyService.findByAll("0102"));
        view.addObject("record",new ReplaceCompanyCertificate());
        return view;
    }
    /***
     * 保存新增信息
     */
    @RequestMapping("save")
    @RequiresPermissions("replaceCertificate:add")
    @ResponseBody
    public AjaxResult save(ReplaceCompanyCertificate replaceCompanyCertificate){
        AjaxResult result = new AjaxResult();
        try {
            replaceCompanyCertificateService.save(replaceCompanyCertificate);
            result.setSuccessful(true);
            result.setMsg("新增成功！");
            return result;
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
    }
    /***
     * 进入换证修改页面
     */
    @RequestMapping("toEditPage/{id}")
    @RequiresPermissions("replaceCertificate:edit")
    public ModelAndView toEditPage(@PathVariable Long id){
        ModelAndView view = new ModelAndView();
        //获取换证信息
        ReplaceCompanyCertificate replaceCompanyCertificate = replaceCompanyCertificateService.findById(id);
        view.addObject("record",replaceCompanyCertificate);
        view.addObject("companyList", companyService.findByAll("0102"));
        view.setViewName("certificate/replaceCertificate/edit");
        return view;
    }
    /***
     * 换证信息查询
     * @param dto 查询参数
     * @return 换证信息列表
     * @throws Exception
     */
    @RequestMapping("query")
    @RequiresPermissions("replaceCertificate:query")
    public @ResponseBody
    AjaxPageResponse searchForTrain(ReplaceCompanyCertificateSearchDTO dto, AjaxPageResponse page){
        try {
            //查询等级证信息
            replaceCompanyCertificateService.query(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }
}
