package com.bcxin.ars.rest.certificate;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.GradeCompleteCerPageSearchDto;
import com.bcxin.ars.model.certificate.GradeCompleteCer;
import com.bcxin.ars.service.certificate.GradeCompleteCerService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;


/**
 * 保安员等级证报名结业证书控制器
 *
 * @author linqinglin
 * @Date 2020-02-04 10:50:12
 */
@Controller
@RequestMapping("gradeCompleteCer")
public class GradeCompleteCerController {

    Logger logger = LoggerFactory.getLogger(GradeCompleteCerController.class);

    @Autowired
    GradeCompleteCerService gradeCompleteCerService;

    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(){
        ModelAndView view = new ModelAndView("certificate/gradeCompleteCer/list");
        return view;
    }

    /**
     * 查看页面
     * @param gradeCompleteCer
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(GradeCompleteCer gradeCompleteCer){
        ModelAndView view = new ModelAndView("certificate/gradeCompleteCer/detail");
        view.addObject("record",gradeCompleteCerService.findById(gradeCompleteCer.getId()));
        return view;
    }

    /**
     * 新增编辑页面
     * @param gradeCompleteCer
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(GradeCompleteCer gradeCompleteCer){
        ModelAndView view = new ModelAndView("certificate/gradeCompleteCer/edit");

        if(gradeCompleteCer.getId() != null){
            view.addObject("record",gradeCompleteCerService.findById(gradeCompleteCer.getId()));
        }else {
            view.addObject("record", gradeCompleteCer);
        }

        return view;
    }


    @RequestMapping("completeCerDetail")
    @Deprecated
    public ModelAndView completeCerDetail(Long personGradeId) throws Exception {
        ModelAndView view = new ModelAndView("personGrade/completeCer");
        view.addObject("content",gradeCompleteCerService.findByPersonGradeIdWithQRCode(personGradeId));
        return view;
    }

    /**
     * 保存
     * @param gradeCompleteCer
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(GradeCompleteCer gradeCompleteCer){
        AjaxResult result = new AjaxResult();
        try {
            gradeCompleteCerService.save(gradeCompleteCer);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(GradeCompleteCerPageSearchDto dto, AjaxPageResponse<GradeCompleteCer> page){
        gradeCompleteCerService.searchForPage(dto,page);
        return page;
    }



    /**
     * 根据报名id查询结业证书详情
     * @param personGradeId
     * @return
     */
    @RequestMapping("findByPersonGradeId")
    @ResponseBody
    @Deprecated
    public AjaxResult findByPersonGradeId(Long personGradeId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(gradeCompleteCerService.findByPersonGradeIdWithQRCode(personGradeId));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}

