package com.bcxin.ars.rest.certificate;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.certificate.CompanyCertificateSearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.ProjectChange;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.CompanyCertificate;
import com.bcxin.ars.service.ProjectChangeService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.certificate.CompanyCertificateService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;

@Controller
@RequestMapping("companyCertificate")
public class CompanyCertificateController {

	private static  final   Logger logger = LoggerFactory.getLogger(CompanyCertificateController.class);

	@Autowired
	private CompanyCertificateService companyCertificateService;

	@Autowired
	private ProjectChangeService projectChangeService;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private SecurityCompanyService companyService;

	@RequestMapping("search")
    @RequiresPermissions("sponsorlicensePrint:query")
	public @ResponseBody AjaxResult search(CompanyCertificateSearchDto dto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				User currentUser = arsUtil.getCurrentUser();
				//机构信息
				Police police = currentUser.getPolice();
				if(police != null) {
					String areacode = police.getAreacode();
					if (areacode.endsWith("0000")) {//省
						dto.setDistrict(areacode.substring(0, 2) + "____");
					} else if (areacode.endsWith("00")) {//市
						dto.setDistrict(areacode.substring(0, 4) + "__");
					} else {//区
						dto.setDistrict(areacode);
					}
				}
				CompanyCertificateSearchDto list =null;
				//只查询申请的
				dto.setApplytype(Constants.TYPE_APPLY);

				list = companyCertificateService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("update")
	public @ResponseBody AjaxResult update(CompanyCertificate companyCertificate) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				companyCertificateService.saveOrUpdate(companyCertificate);
				result.setSuccessful(true);
				result.setData(companyCertificate);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	/***
	 * 项目变更生成证书
	 * @param companyCertificate
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("updateLegalchange")
    @RequiresPermissions("legalchange:certificate")
	public @ResponseBody AjaxResult updateLegalchange(CompanyCertificate companyCertificate) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				companyCertificateService.saveOrUpdateForLegalchange(companyCertificate);
				result.setSuccessful(true);
				result.setData(companyCertificate);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	@RequestMapping("updateAndCreatePDF")
    @RequiresPermissions("sponsorlicensePrint:edit")
	public @ResponseBody AjaxResult updateAndCreatePDF(CompanyCertificate companyCertificate) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				companyCertificateService.updateAndCreatePDF(companyCertificate);
				result.setSuccessful(true);
				result.setData(companyCertificate);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 批量生成pdf文件
	 */
	@RequestMapping("createPdfBatch")
	public @ResponseBody AjaxResult createPdfBatch() {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				companyCertificateService.createPdfBatch();
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("updateCompanyCertificate")
	public @ResponseBody AjaxResult updateCompanyCertificate(CompanyCertificate companyCertificate) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				result.setSuccessful(true);
				companyCertificateService.updateCompanyCertificate(companyCertificate);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(CompanyCertificate companyCertificate) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				result.setSuccessful(true);
				companyCertificateService.delete(companyCertificate);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取明细
	 * 
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id") Long id,String type) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			/***
			 * 根据id获取证书信息，并且根据打印类型（正副本）生成二维码
			 */
			CompanyCertificate companyCertificate = companyCertificateService.findById(id,type);
			//获取项目变更记录信息
			List<ProjectChange> projectChangeList = projectChangeService.findByCertificateIdAndType(companyCertificate.getId().toString(),BusinessType.BAFWGS);
			if(null!=companyCertificate){
				companyCertificate.setProjectChangeList(projectChangeList);
			}
			result.setSuccessful(true);
			result.setData(companyCertificate);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 *
	 * @return
	 */
	@RequestMapping("findByIdV2/{id}")
	public @ResponseBody AjaxResult findByIdV2(@PathVariable("id") Long id,String type) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			/***
			 * 根据id获取证书信息，并且根据打印类型（正副本）生成二维码
			 */
			CompanyCertificate companyCertificate = companyCertificateService.findByIdV2(id,type);
			//获取项目变更记录信息
			List<ProjectChange> projectChangeList = projectChangeService.findByCertificateIdAndType(companyCertificate.getId().toString(),BusinessType.BAFWGS);
			if(null!=companyCertificate){
				companyCertificate.setProjectChangeList(projectChangeList);
			}
			result.setSuccessful(true);
			result.setData(companyCertificate);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据许可证号获取
	 *
	 * @return
	 */
	@RequestMapping("findByXkzh/{xkzh}")
	public @ResponseBody AjaxResult findByXkzh(@PathVariable("xkzh") String xkzh) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			String xkzhNew = new String(xkzh.getBytes("iso-8859-1") ,"UTF-8");
			List<CompanyCertificate> companyCertificateList = companyCertificateService.findByXkzh(xkzhNew);
			result.setSuccessful(true);
			result.setData(companyCertificateList);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	/**
	 * 根据许可证号获取
	 *
	 * @return
	 */
	@RequestMapping("findDataByXkzh")
	public @ResponseBody AjaxResult findDataByXkzh(String xkzh) {
		AjaxResult result = new AjaxResult();
		try {
			List<CompanyCertificate> companyCertificateList = companyCertificateService.findByXkzh(xkzh);
			result.setSuccessful(true);
			result.setData(companyCertificateList);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据许可证号获取
	 *
	 * @return
	 */
	@RequestMapping("findDataByXkzhHistory")
	public @ResponseBody AjaxResult findDataByXkzhHistory(String xkzh) {
		AjaxResult result = new AjaxResult();
		try {
			List<CompanyCertificate> companyCertificateList = companyCertificateService.findDataByXkzhHistory(xkzh);
			result.setSuccessful(true);
			result.setData(companyCertificateList);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}



	/**
	 * 根据许可证号获取明细
	 *
	 * @return
	 */
	@RequestMapping("findByCompanyname")
	public @ResponseBody AjaxResult findByCompanyname(CompanyCertificate companyCertificate) {
		AjaxResult result = new AjaxResult();
		try {
			//变更后的名字跟变更前的名字
			String[] companyname = companyCertificate.getGsmc().split(",");
			CompanyCertificate dbcompanyCertificate=null;
//			if(companyname[0]!=null&& !companyname[0].equals("")){
//				 dbcompanyCertificate = companyCertificateService.findByCompanyname(companyname[0]);
//			}
//			if(companyname[1]!=null&& !companyname[1].equals("")){
//				dbcompanyCertificate = companyCertificateService.findByCompanyname(companyname[1]);
//			}
			//修改
			dbcompanyCertificate = companyCertificateService.findByCompanyId(companyCertificate.getCompanyid());

			//只要存在记录，不管名字是变更后还是变更前，前端都不弹框，否则弹框录入

			if(dbcompanyCertificate!=null){
				result.setData(dbcompanyCertificate);
				result.setSuccessful(true);
			}else{
				result.setSuccessful(false);
				result.setMsg("请先生成证书，再变更");
			}

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}



	/**
	 * 根据保安服务公司申报ID获取明细
	 * 
	 * @return
	 */
	@RequestMapping("findBySponsorLicenseId/{id}")
	public @ResponseBody AjaxResult findBySponsorLicenseId(@PathVariable("id") Long id) {
		AjaxResult result = new AjaxResult();
		try {
			CompanyCertificate companyCertificate = companyCertificateService.findBySponsorLicenseId(id);
			result.setSuccessful(true);
			result.setData(companyCertificate);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据申请ID更新打印状态
	 * @return
	 */
	@RequestMapping("updatePrintedByid/{id}")
	public @ResponseBody AjaxResult updatePrintedByidArr(@PathVariable("id")Long id) {
		AjaxResult result = new AjaxResult();

		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				companyCertificateService.updatePrintedByid(id);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	@RequestMapping("list/index")
	public ModelAndView listPage(CompanyCertificateSearchDto searchDto){
		ModelAndView view = new ModelAndView("certificate/company/list"+configUtils.getCurrentNative());
		view.addObject("record",searchDto);
		return view;
	}

	@RequestMapping("searchForPage")
	@RequiresPermissions("sponsorlicensePrint:query")
	public @ResponseBody
	AjaxPageResponse searchForPage(CompanyCertificateSearchDto dto, AjaxPageResponse page){
		try {
			//查询等级证信息
			companyCertificateService.searchForPage(dto, page);
			return page;
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
	}

	/***
	 * 进入换证新增页面
	 */
	@RequestMapping("toAddPage")
	public ModelAndView toAddPage(){
		ModelAndView view = new ModelAndView("certificate/company/add");
		view.addObject("companyList", companyService.findByAll("0102"));
		CompanyCertificate companyCertificate = new CompanyCertificate();
		//默认设置新增系统驻入的公司
		companyCertificate.setIsInSystem(Constants.IS_IN_SYS);
		view.addObject("record",companyCertificate);
		return view;
	}
	/***
	 * 保存信息
	 */
	@RequestMapping("save")
	@ResponseBody
	public AjaxResult saveForRepair(CompanyCertificate companyCertificate){
		AjaxResult result = new AjaxResult();
		try {
			companyCertificateService.saveForRepair(companyCertificate);
			result.setSuccessful(true);
			result.setMsg("新增成功！");
			return result;
		}catch (Exception e){
			logger.error(e.getMessage(), e);
			throw e;
		}
	}
	/***
	 * 进入修改页面
	 */
	@RequestMapping("toEditPage/{id}")
	public ModelAndView toEditPage(@PathVariable Long id){
		ModelAndView view = new ModelAndView("certificate/company/edit");
		CompanyCertificate companyCertificate = companyCertificateService.findById(id);
		//显示未驻入系统的公司名称
		String isInSystem = companyCertificate.getIsInSystem();
		if(!StringUtils.isEmpty(isInSystem) && isInSystem.equals(Constants.NOT_IN_SYS)){
			String gsmc = companyCertificate.getGsmc();
			companyCertificate.setGsmcDefine(gsmc);
		}
		view.addObject("record",companyCertificate);
		view.addObject("companyList", companyService.findByAll("0102"));
		return view;
	}
}
