package com.bcxin.ars.rest.certificate;


import com.bcxin.ars.model.certificate.ComCertificateSnapshot;
import com.bcxin.ars.service.certificate.ComCertificateSnapshotService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.CerUtil;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;


/**
 * 保安服务公司快照保存表
 *
 * @author yyx
 * @Date 2020-04-24 16:23:31
 */
@Controller
@RequestMapping("mobile/comCertificateSnapshot")
public class ComCertificateSnapshotController {

    Logger logger = LoggerFactory.getLogger(ComCertificateSnapshotController.class);

    @Autowired
    private ComCertificateSnapshotService comCertificateSnapshotService;

    @Autowired
    private ConfigUtils configUtils;

    /**
     * 保安服务公司许可证二维码扫描查看页面
     * @param qrCodeId
     * @param type
     * @return
     */
    @RequestMapping("findByQrCodeId/{qrCodeId}")
    public ModelAndView comFindByQrCodeId(@PathVariable Long qrCodeId, String type) {
        ModelAndView view = null;
        //根据二维码id查询信息
        ComCertificateSnapshot comCertificateSnapshot = comCertificateSnapshotService.findByQrCodeId(qrCodeId);
        try{
            //许可证号
            String zkzh = configUtils.getValueByKey(Constants.CURRENT_NATIVE_SHORT);
            zkzh = zkzh + "公保服";
            comCertificateSnapshot.setXkzh(comCertificateSnapshot.getXkzh().replace(zkzh,""));
            //注册资本的转换
            if(comCertificateSnapshot.getZczb()!=null) {
                comCertificateSnapshot.setZczb(CerUtil.digitUppercase(Double.parseDouble(comCertificateSnapshot.getZczb())));
            }
            //服务范围的转换
            comCertificateSnapshot.setFwfw(CerUtil.formatManagement(comCertificateSnapshot.getFwfw(),comCertificateSnapshot.getOtherSecScopeType()));

        }catch (Exception e){
            logger.error("保安服务公司许可证注册资本或者服务范围或者许可证号的转换失败");
        }
        //正本页面
        if(Constants.CERPRINTTYPE_Z.equals(type)) {
            view = new ModelAndView("mobile/certificate/company");
        }else{
            //副本页面
            view = new ModelAndView("mobile/certificate/companyCopy");
        }
        view.addObject("record",comCertificateSnapshot);
        return view;
    }
}

