package com.bcxin.ars.rest.approve;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.approve.ApproveTempLink;
import com.bcxin.ars.service.approve.ApproveTempLinkService;

/**
 * @author：lql @date：2018/01/17 17:00
 * @description：审批环节Controller
 */
@Controller
@RequestMapping("approveTempLink")
public class ApproveTempLinkController {

	Logger logger = LoggerFactory.getLogger(ApproveTempLinkController.class);

	@Autowired
	private ApproveTempLinkService approveTempLinkService;

	@RequestMapping("approveDesign")
	public ModelAndView approveDesign(Long tempId) {
		ModelAndView view = new ModelAndView();
		// 跳转到审批环节列表界面
		view.addObject("tempId", tempId);
		view.setViewName("approveDesign/newapprovelink");
		return view;
	}

	@RequestMapping("selectPeople")
	public ModelAndView selectPeople() {
		ModelAndView view = new ModelAndView();
		// 跳转到选择审批人员界面
		view.setViewName("approveDesign/selectPeople");
		return view;
	}

	@RequestMapping("save")
	public @ResponseBody AjaxResult save(Long linkId, Long tempId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			// 判断是否是省级机构登陆，如果是省级机构登陆，则获取省级对应的所有市级模板进行添加环节
			approveTempLinkService.save(linkId, tempId);
			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("changeOrder/{idArray}")
	public @ResponseBody AjaxResult changeOrder(@PathVariable("idArray") Long[] idArray) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			// 上移下移
			for (int i = 0; i < idArray.length; i++) {
				ApproveTempLink approveTempLink = approveTempLinkService.findById(idArray[i]);
				approveTempLink.setSeq(i + 1);
				approveTempLinkService.update(approveTempLink);
			}

			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("changeOrderUp/{idArray}")
	public @ResponseBody AjaxResult changeOrderUp(@PathVariable("idArray") Long[] idArray) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			approveTempLinkService.updateOrderUp(idArray);
			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("changeOrderDown/{idArray}")
	public @ResponseBody AjaxResult changeOrderDown(@PathVariable("idArray") Long[] idArray) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			approveTempLinkService.updateOrderDown(idArray);
			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id") Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			approveTempLinkService.delete(id);
			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

}
