package com.bcxin.ars.rest.approve;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSycDto;
import com.bcxin.ars.dto.approve.ApproveAreaProcessDataDto;
import com.bcxin.ars.dto.approve.ApproveTempDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.*;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.approve.ApproveAreaProcessService;
import com.bcxin.ars.service.approve.ApproveLinkLevelService;
import com.bcxin.ars.service.approve.ApproveTempLinkService;
import com.bcxin.ars.service.approve.ApproveTempService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.CipherDESUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.Encodes;
import com.bcxin.ars.util.approval.BusinessType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author：wangcy @date：2018/01/16 0016 19:41
 * @description：审批模板controller
 */
@Controller
@RequestMapping("approveTemp")
public class ApproveTempController {

	Logger logger = LoggerFactory.getLogger(ApproveTempController.class);

	@Autowired
	private ApproveTempService approveTempService;

	@Autowired
	private ApproveTempLinkService approveTempLinkService;

	@Autowired
	private SysareaService sysareaService;

	@Autowired
	private ApproveAreaProcessService approveAreaProcessService;

	@Autowired
	private ApproveLinkLevelService approveLinkLevelService;

	@Autowired
	private PoliceService policeService;

	@Autowired
	private ArsUtil arsUtil;

	@Value("${temp-folder}")
	private String tempfolder;

	/**
	 * @Author: wangcy
	 * @Description:获取所有模板数据
	 * @Date: 2018/01/19 0019 13:21
	 */
	@RequestMapping(value = "list", method = RequestMethod.GET)
	public @ResponseBody AjaxResult list() throws Exception {
		AjaxResult result = new AjaxResult();
		// 获取模板数据
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				// 获取所有模板数据
				List<ApproveTempDto> approveTempDtoList = approveTempService.findDto();
				result.setSuccessful(true);
				result.setData(approveTempDtoList);
			} else {
				result.setSuccessful(false);
			}

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * @Author: wangcy
	 * @Description:根据ID获取模板
	 * @Date: 2018/01/19 0019 10:51
	 */
	@RequestMapping(value = "findById/{id}", method = RequestMethod.GET)
	public @ResponseBody AjaxResult findById(@PathVariable("id") Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				ApproveTemp approveTemp = approveTempService.findById(id);
				result.setSuccessful(true);
				result.setData(approveTemp);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * @Author: wangcy
	 * @Description:修改模板
	 * @Date: 2018/01/19 0019 10:51
	 */
	@RequestMapping(value = "update", method = RequestMethod.POST)
	public @ResponseBody AjaxResult update(ApproveTemp approveTemp) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				approveTempService.update(approveTemp);
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("listTemp")
	public ModelAndView listInit() {
		ModelAndView view = new ModelAndView();
		view.setViewName("approveTemp/list");
		view.addObject("approveTempDtoList", approveTempService.findDto());
		return view;
	}

	@RequestMapping("checkTempConfigComplete/{tempId}")
	public @ResponseBody AjaxResult checkTempConfigComplete(@PathVariable("tempId") Long tempId, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			ApproveTemp approveTemp = approveTempService.findById(tempId);
			// 上级已配置
			boolean configStatus = approveTempService.checkTempConfigComplete(approveTemp);
			result.setSuccessful(configStatus);
			if(!configStatus){
				result.setMsg("该审批业务上级机构未配置！");
			}

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("processeditor/{tempId}")
	public ModelAndView editInit(@PathVariable("tempId") Long tempId) {
		// 判断当前用户上级机构是否都配置完成，如果未配置完成，则不能进行当前机构配置
		ModelAndView view = new ModelAndView();
		ApproveTemp approveTemp = approveTempService.findById(tempId);
		List<ApproveTempLink> approveTempLinkList = approveTempLinkService.findByTempId(tempId);
		view.addObject("approveTempLinkList", approveTempLinkList);
		for (ApproveTempLink approveTempLink : approveTempLinkList) {
			approveTempLink.getLinkLevels();
		}
		view.addObject("approveTemp", approveTemp);
		view.addObject("cityList", sysareaService.findCurrentSystemAreaList());
			view.setViewName("approveTemp/processeditor");
		return view;

	}

	@RequestMapping("showprocesseditor/{tempId}")
	public ModelAndView showeditInit(@PathVariable("tempId") Long tempId) {
		ModelAndView view = new ModelAndView();
		ApproveTemp approveTemp = approveTempService.findById(tempId);
		List<ApproveTempLink> approveTempLinkList = approveTempLinkService.findByTempId(tempId);
		view.addObject("approveTempLinkList", approveTempLinkList);
		for (ApproveTempLink approveTempLink : approveTempLinkList) {
			approveTempLink.getLinkLevels();
		}
		view.addObject("approveTemp", approveTemp);
		view.addObject("cityList", sysareaService.findCurrentSystemAreaList());
		view.setViewName("approveTemp/showprocesseditor");
		return view;
	}

	@RequestMapping("editTemp/{id}")
	public ModelAndView editTemp(@PathVariable("id") Long id) {
		ModelAndView view = new ModelAndView();
		view.setViewName("approveTemp/edit");
		// ApproveTemp approveTemp = approveTempService.findById(id);
		view.addObject("content", approveTempService.findById(id));
		return view;
	}

	@RequestMapping(value = "findApproveOrgListSj", method = RequestMethod.POST)
	public @ResponseBody AjaxResult findApproveOrgListSj(ApproveTemp approveTemp) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<ApproveTemp> list = approveTempService.findApproveOrgListSj(approveTemp);
			if (list.size() > 0) {
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}

			result.setData(list);

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 批量导入审批流程设置数据(数据库导入）
	 */
	@RequestMapping("importData")
	public @ResponseBody AjaxResult importData(MultipartFile file, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User currentUser = arsUtil.getCurrentUser();
			Date now = new Date();
			String fileName = now.getTime() + "_" + file.getOriginalFilename();
			String dirDate = DateUtil.systemDate.format(now);
			File dir = new File(tempfolder + dirDate);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			String targetPath = tempfolder + dirDate + "/" + fileName;
			File targetFile = new File(targetPath);
			logger.info("执行文件上传..." + targetFile);
			file.transferTo(targetFile);

			BufferedReader br = new BufferedReader(new FileReader(targetFile));
			StringBuffer content = new StringBuffer();
			// 获取文件内容
			String lineTxt = null;
			while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
				content.append(lineTxt);
			}
			br.close();

			// TODO
			String jsonStr = new String(
					CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));
			DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);
			if (dataSycDto != null) {
				if (dataSycDto.getDataType().equals(Constants.DATASYC_APPROVEAREAPROCESS_LIST)) {

					new Thread(() -> { // 异步处理
						try {
							ApproveAreaProcessDataDto approveDto = JSONObject.parseObject(dataSycDto.getData(),
									ApproveAreaProcessDataDto.class);

							if (approveDto != null) {
								List<ApproveAreaProcess> approveAreaProcessList = approveDto
										.getApproveAreaProcessList();
								List<ApproveTempLinkRela> approveTempLinkRelaList = approveDto
										.getApproveTempLinkRelaList();
								List<ApproveLinkLevel> approveLinkLevelList = approveDto.getApproveLinkLevelList();
								approveAreaProcessService.insertBatchTemp(approveAreaProcessList);
								approveTempLinkService.insertBatchTemp(approveTempLinkRelaList);
								approveLinkLevelService.insertBatchTemp(approveLinkLevelList);
							}
							//MessageUtil.sendMessage(currentUser.getPhone(), Constants.POLICE_IMPORTDATA_MESSAGE,messageLogDao);

						} catch (Exception e) {
							//MessageUtil.sendMessage(currentUser.getPhone(), Constants.POLICE_IMPORTDATA_MESSAGE_FAIL);
							e.printStackTrace();
						}
					}).start();

					result.setMsg("数据导入中，导入成功后将会短信通知您！");
					result.setSuccessful(true);
				} else {
					result.setMsg("导入失败，非审批流程设置的数据！");
					result.setSuccessful(false);
				}
			} else {
				result.setMsg("导入失败，非审批流程设置的数据！");
				result.setSuccessful(false);
			}

			Map<String, Object> resultMap = new HashMap<String, Object>();
			resultMap.put("faildFilePath", "");
			result.setData(resultMap);
			result.setSuccessful(true);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/***
	 * 获取审批级别
	 * @param cityCode 市级编码
	 * @param businessTypeCode 业务编码
	 * @param sponsorlicenseType 保安公司类型 01-保安公司，02-武装押运，03-合资
	 * @return
	 * @throws Exception 异常
	 */
	@RequestMapping("getMaxApproveLevel")
	public @ResponseBody AjaxResult getMaxApproveLevel(String cityCode,String businessTypeCode,String sponsorlicenseType) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			/***
			 * edit subh 2019-02-27
			 * 增加保安公司类型参数，用于判断申报保安公司业务，保安公司、武装押运、合资返回的流程，如果不是保安公司业务，则根据业务类型编码返回Key
			 */
			String businessType = BusinessType.getBusinessTypeName(businessTypeCode,sponsorlicenseType);
			String tempCode = businessType + "-" + cityCode;
			String maxApproveLevel = approveTempService.getMaxApproveLevel(tempCode);
			result.setData(maxApproveLevel);
			result.setSuccessful(true);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
    /**
     * 获取当前市级最小级机构
     * @param areaCode 市级编码
     * @param businessTypeCode 业务编码
     * @param sponsorlicenseType 业务编码
     * @return 最小级的机构
     */
    @RequestMapping("getApprovalMinOrgTypePolice")
    public @ResponseBody AjaxResult getApprovalMinOrgTypePolice(String areaCode,String businessTypeCode,String sponsorlicenseType) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
			Police police = policeService.getApprovalMinOrgTypePolice(areaCode,businessTypeCode,sponsorlicenseType);
			if(police == null && !areaCode.endsWith("00")){
				areaCode = areaCode.substring(0,4)+"00";
				police = policeService.getApprovalMinOrgTypePolice(areaCode,businessTypeCode,sponsorlicenseType);
			}
            result.setData(police);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
