package com.bcxin.ars.rest.approve;

import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.approve.ApproveTempDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.approve.ApproveLinkLevelDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.ApproveLinkLevel;
import com.bcxin.ars.model.approve.ApproveTemp;
import com.bcxin.ars.service.approve.ApproveLinkLevelService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.List;

/**
 * @author：wangcy @date：2018/01/19 0019 14:53
 * @description：审批环节层级Controller
 */
@Controller
@RequestMapping("approveLinkLevel")
public class ApproveLinkLevelController {

	Logger logger = LoggerFactory.getLogger(ApproveLinkLevelController.class);

	@Autowired
	private ApproveLinkLevelService approveLinkLevelService;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ConfigDao configDao;

	@Autowired
	private ApproveTempDao approveTempDao;

	/**
	 * @Author: wangcy
	 * @Description:根据环节查询审批环节层级
	 * @Date: 2018/01/19 0019 10:51
	 */
	@RequestMapping(value = "findByTempLinkRelaId/{tempLinkRelaId}", method = RequestMethod.GET)
	public @ResponseBody AjaxResult findByTempLinkRelaId(@PathVariable("tempLinkRelaId") Long tempLinkRelaId)
			throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			// User user = arsUtil.getCurrentUser();
			// 审批环节必须存在不能是删除过的
			// ApproveLink approveLink =
			// approveLinkService.findById(approveLinkId);
			// if (user != null && approveLink != null) {
			List<ApproveLinkLevel> approveLinkLevelList = approveLinkLevelService.findByTempLinkRelaId(tempLinkRelaId);
			result.setSuccessful(true);
			result.setData(approveLinkLevelList);
			// } else {
			// result.setSuccessful(false);
			// }
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * @Author: wangcy
	 * @Description:删除审批环节层级
	 * @Date: 2018/01/19 0019 10:51
	 */
	@RequestMapping(value = "delete", method = RequestMethod.GET)
	public @ResponseBody AjaxResult findByApproveLinkId(ApproveLinkLevel approveLinkLevel) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			// 审批环节层级必须存在不能是删除过的

			if (user != null && approveLinkLevel.getId() != null) {
				approveLinkLevelService.delete(approveLinkLevel);
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * @Author: wangcy
	 * @Description:修改或者添加审批环节层级
	 * @Date: 2018/01/19 0019 10:51
	 */
	@RequestMapping(value = "update", method = RequestMethod.POST)
	public @ResponseBody AjaxResult update(ApproveLinkLevelDto approveLinkLevelDto) throws Exception {
		AjaxResult result = new AjaxResult();
		String tempCode = "";
		try {
			User user = arsUtil.getCurrentUser();

			// if (user != null && approveLinkLevelDto.getApproveLinkId()!=null)
			// {
			// 审批环节必须存在不能是删除过的
			// ApproveLink approveLink =
			// approveLinkService.findById(approveLinkLevelDto.getApproveLinkId());
			// if (approveLink == null){
			// result.setSuccessful(false);
			// }
			/***
			 * 1.根据模板ID获取模板信息
			 */
			ApproveTemp curApproveTemp = approveTempDao.findById(approveLinkLevelDto.getApproveTempId());
			tempCode = curApproveTemp.getTempCode();
			/**
			 *2.获取模板的配置，检查该模版是否被启用，同一个市不能存在有二个用户以上同样启用流程
			 */
			Config config = configDao.findByKey(tempCode);
			/**
			 * 3.模板的配置表值为0的话，证明有二个用户同时启动，提示其它人正在启动该流程
			 */
			if ( config == null || "0".equals(config.getValue())) {

				/***
				 * 4.启动流程时先把流程锁定，不允许其它人启动流程
				 */
				if(config == null){
					config = new Config();
					config.setValue("1");
					config.setKey(tempCode);
					config.setCreateTime(new Date());
					config.setUpdateTime(new Date());
					config.setUpdateBy("system");
					config.setActive(true);
					configDao.save(config);
				}else {

					config.setValue("1");
					configDao.update(config);
				}

				approveLinkLevelService.saveOrUpdate(approveLinkLevelDto);
				/***
				 * 5.启动成功之后解锁流程
				 */
				config.setValue("0");
				configDao.update(config);


				List<ApproveLinkLevel> approveLinkLevelList = approveLinkLevelService
						.findByTempLinkRelaId(approveLinkLevelDto.getTempLinkRelaId());

				result.setData(approveLinkLevelList);
				result.setSuccessful(true);
			// } else {
			//// result.setSuccessful(false);
			//// }

			}else{
				result.setSuccessful(false);
				result.setMsg("当前有其它人正在启动该流程，请稍后再试");
			}
		} catch (Exception e) {
			/***
			 * 6.出现异常的时候解锁流程配置
			 */
			Config config = configDao.findByKey(tempCode);
			logger.error(e.getMessage(), e);
			config.setValue("0");
			configDao.update(config);
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

}
