package com.bcxin.ars.rest.approve;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.approve.ApproveLinkSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.ApproveLink;
import com.bcxin.ars.service.approve.ApproveLinkService;
import com.bcxin.ars.service.approve.ApproveTempService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * @author：lql @date：2018/01/17 17:00
 * @description：审批环节Controller
 */
@Controller
@RequestMapping("approveLink")
public class ApproveLinkController {

	Logger logger = LoggerFactory.getLogger(ApproveLinkController.class);

	@Autowired
	private ApproveLinkService approveLinkService;

	@Autowired
	private ApproveTempService approveTempService;

	@Autowired
	private ArsUtil arsUtil;

	@RequestMapping("listInit")
	public ModelAndView listInit() {
		ModelAndView view = new ModelAndView();
		view.setViewName("approveLink/list");
		return view;
	}

	@RequestMapping("addInit")
	public ModelAndView addInit() {
		ModelAndView view = new ModelAndView("approveLink/edit");
		view.addObject("tempList", approveTempService.findDto());
		return view;
	}

	@RequestMapping("editInit/{id}")
	public ModelAndView editInit(@PathVariable("id") Long id) {
		ModelAndView view = new ModelAndView("approveLink/edit");
		ApproveLink approveLink = approveLinkService.findById(id);
		view.addObject("content", approveLink);
		view.addObject("tempList", approveTempService.findDto());
		return view;
	}

	@RequestMapping("save")
	public @ResponseBody AjaxResult save(ApproveLink approveLink) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			approveLinkService.saveOrUpdate(approveLink);
			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id") Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			ApproveLink approveLink = approveLinkService.findById(id);
			result.setSuccessful(true);
			result.setData(approveLink);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id") Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			ApproveLink approveLink = approveLinkService.findById(user.getPolice().getId());
			approveLinkService.delete(approveLink);
			result.setSuccessful(true);
			result.setMsg("操作完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("search")
	public @ResponseBody AjaxResult search(ApproveLinkSearchDto searchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			result.setData(approveLinkService.search(searchDto));
			result.setSuccessful(true);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	// @RequestMapping("testWeb")
	// public ModelAndView testWeb() {
	// ModelAndView view = new ModelAndView();
	// view.setViewName("/approveTemp/processeditor");
	//
	// return view;
	// }

}
