package com.bcxin.ars.rest.act;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.act.ActivitiTaskSearchDto;
import com.bcxin.ars.dto.act.MyTask;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.util.ArsUtil;
import org.activiti.engine.*;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Controller
@RequestMapping("activiti/task")
public class TaskActivitiController {

    private Logger logger = LoggerFactory.getLogger(TaskActivitiController.class);

		// 引入activiti自带的Service接口
		@Resource
		private TaskService taskService;

		@Resource
		private RepositoryService repositoryService;

		@Resource
		private RuntimeService runtimeService;

		@Resource
		private FormService formService;

		@Resource
		private HistoryService historyService;

	    @Autowired
	    private ArsUtil arsUtil;
	    
	@RequestMapping("/search")
	public @ResponseBody
    AjaxResult search(ActivitiTaskSearchDto searchDto) throws Exception{
		AjaxResult result = new AjaxResult();
        try {
        	User currentUser = arsUtil.getCurrentUser();
			String candidateGroup = "firstapproval";
			// 获取总记录数
			System.out.println("用户ID："+currentUser.getId()+"\n"+"名称:"+searchDto.getTaskName() );
			long total=taskService.createTaskQuery()
					.taskCandidateGroup(candidateGroup)
//					.taskNameLike("%"+searchDto.getTaskName()+"%")
					.count(); // 获取总记录数
			//有想法的话，可以去数据库观察  ACT_RU_TASK 的变化
			List<Task> taskList=taskService.createTaskQuery()
					// 根据用户id查询
					.taskCandidateGroup(candidateGroup)
					// 根据任务名称查询
//					.taskNameLike("%"+searchDto.getTaskName()+"%")
					// 返回带分页的结果集合
					.listPage(searchDto.getStart(), searchDto.getNumPerPage());
			//这里需要使用一个工具类来转换一下主要是转成JSON格式
			List<MyTask> myTaskList=new ArrayList<MyTask>();
			for(Task t:taskList){
				MyTask myTask=new MyTask();
				myTask.setId(t.getId());
				myTask.setName(t.getName());
				myTask.setCreateTime(t.getCreateTime());
				myTaskList.add(myTask);
			}
			searchDto.setData(myTaskList);
			searchDto.setTotalCount(total);
			result.setSuccessful(true);
			result.setData(searchDto);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
	}
}
