package com.bcxin.ars.rest;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.UserRoleSearchDto;
import com.bcxin.ars.model.UserRole;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.UserRoleService;
import com.bcxin.ars.service.util.ArsUtil;

/**
 * 用户角色关联
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月2日 下午4:15:22
 * @注意事项 </b>
 * <b>
 */
@Controller
@RequestMapping("userRole")
public class UserRoleController {

	Logger logger = LoggerFactory.getLogger(UserRoleController.class);
	
	@Autowired
	private UserRoleService userRoleService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	/**
	 * 查询用户关联角色列表
	 * <b>Function </b> 
	 * 
	 * @param dto
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午4:17:13
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(UserRoleSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
//				if(dto.getUserid() == null){
//					dto.setUserid(user.getId());
//				}
				UserRoleSearchDto list = userRoleService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 新增或者修改用户关联角色
	 * <b>Function </b> 
	 * 
	 * @param userRole
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午4:17:33
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(UserRole userRole) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				userRoleService.saveOrUpdate(userRole);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 删除用户关联角色
	 * <b>Function </b> 
	 * 
	 * @param userRole
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午4:17:50
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(UserRole userRole) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				userRoleService.delete(userRole);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取用户角色关联明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			UserRole userRole = userRoleService.findById(id);
			result.setSuccessful(true);
			result.setData(userRole);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据用户id查询角度角色关联信息
	 * <b>Function </b> 
	 * 
	 * @param userid
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午4:18:11
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("findByUserId")
	public @ResponseBody AjaxResult findByUserId(Long userId, String roleType) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<UserRole> userRole = userRoleService.findByUserIdAndRoleType(userId,roleType);
			result.setSuccessful(true);
			result.setData(userRole);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据角色id查询角度角色关联信息
	 * <b>Function </b> 
	 * 
	 * @param roleid
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午4:18:33
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("findByRoleId")
	public @ResponseBody AjaxResult findByRoleId(Long roleid, String roleType) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<UserRole> userRoles = userRoleService.findByRoleIdAndRoleType(roleid,roleType);
			result.setSuccessful(true);
			result.setData(userRoles);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
