package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.TaskScheduleDetailDto;
import com.bcxin.ars.dto.TaskScheduleDto;
import com.bcxin.ars.dto.TaskScheduleListDto;
import com.bcxin.ars.model.SecurityCompanySchedule;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskPerson;
import com.bcxin.ars.model.task.TaskPersonSchedule;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.task.UrgentTeamService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;



/**
 * Created by Darren on 2017/4/2.
 */
@Controller
@RequestMapping("urgentTeam")
public class UrgentTeamController {

    private static final Logger logger = LoggerFactory.getLogger(TaskController.class);

    @Autowired
    public UrgentTeamService urgentTeamService;
    @Autowired
    private SecurityPersonService securityPersonService;

    /**
     * 保存紧急小队人员信息
     * @return
     */
    @RequestMapping("save")
    public @ResponseBody
    AjaxResult save(String personids) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            urgentTeamService.saveUrgentTeam(personids);
            result.setData(securityPersonService.queryUrgentPersonByCompnyId());
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
