package com.bcxin.ars.rest;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.SecurityProfessionLevel;
import com.bcxin.ars.util.Constants;

@Controller
@RequestMapping("prolvl")
public class SecurityProfessionLevelController {
	
	/**
	 * 获取专业级别列表
	 * @param request
	 * @return
	 */
	@RequestMapping("findAll")
	public @ResponseBody AjaxResult findAll(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.PROFESSION_LEVEL_LIST);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 获取专业级别列表
	 * @param request
	 * @return
	 */
	@RequestMapping("findAllForMap")
	public @ResponseBody AjaxResult findAllForMap(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.PROFESSION_LEVEL_MAP);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 根据ID获取专业级别
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id, HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.PROFESSION_LEVEL_MAP);
		if(data != null) {
			Map<Long, SecurityProfessionLevel> lvlMap = (Map<Long, SecurityProfessionLevel>)data;
			SecurityProfessionLevel lvl = lvlMap.get(id);
			if(lvl != null) {
				result.setSuccessful(true);
				result.setData(lvl);
			} else {
				result.setSuccessful(false);
				result.setMsg("未找到常量数据。ID:" + id);
			}
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
}
