package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SecurityPersonPractitionerDto;
import com.bcxin.ars.model.SecurityConfesscompany;
import com.bcxin.ars.model.SecurityPersonPractitioner;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SecurityPersonPractitionerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

@Controller
@RequestMapping("practitioner")
public class SecurityPersonPractitionerController {

    private Logger logger = LoggerFactory.getLogger(SecurityPersonPractitionerController.class);

    @Autowired
    private SecurityPersonPractitionerService securityPersonPractitionerService;

    @Autowired
    private ArsRestUtil arsUtil;

    /**
     * 根据ID获取保安员从业情况
     *
     * @param id
     * @param request
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody
    AjaxResult findById(@PathVariable("id") Long id, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SecurityPersonPractitioner securityPersonPractitioner = securityPersonPractitionerService.findById(id);
            result.setSuccessful(true);
            result.setData(securityPersonPractitioner);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 删除保安员从业情况
     *
     * @param securityPersonPractitioner 保安员从业情况
     * @param request
     * @return
     */
    @RequestMapping(value = "delete/{id}", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult delete(SecurityPersonPractitioner securityPersonPractitioner, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                securityPersonPractitioner = securityPersonPractitionerService.findById(securityPersonPractitioner.getId());
                if (securityPersonPractitioner.getActive()) {
                    securityPersonPractitionerService.delete(securityPersonPractitioner);
                }
                result.setSuccessful(true);
                result.setData(securityPersonPractitioner.getId());
            } else {
                result.setSuccessful(false);
                result.setMsg("操作有误！");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员从业情况列表
     *
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("searchForPractitioner")
//	@RequiresPermissions("search:read")
    public @ResponseBody
    AjaxResult searchForPractitioner(SecurityPersonPractitionerDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SecurityPersonPractitionerDto data = securityPersonPractitionerService.search(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 创建或更新保安员从业情况
     *
     * @param securityPersonPractitioner 保安员从业情况
     * @return
     */
    @RequestMapping("saveOrUpdate")
    public @ResponseBody
    AjaxResult update(SecurityPersonPractitioner securityPersonPractitioner, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            securityPersonPractitionerService.saveOrUpdate(securityPersonPractitioner);
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }
}
