package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.SecurityPersonExperience;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonExperienceService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RequestMapping("securityPersonExperience")
@Controller
public class SecurityPersonExperienceController {

	Logger logger = LoggerFactory.getLogger(SecurityPersonExperienceController.class);
	
	@Autowired
	private ArsRestUtil arsUtil;
	
	@Autowired
	private SecurityPersonExperienceService securityPersonExperienceService;
	
	@Autowired
	private SecurityCompanyService companyService;

	@Autowired
	private SecurityPersonService personService;
	
	@RequestMapping("save")
	public @ResponseBody AjaxResult save(Long id,HttpServletRequest request)throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User loginUser = arsUtil.getCurrentUser();
			
			SecurityCompany company = null;
			if(loginUser.getPlatform() == 2){
				company = companyService.findByUserid(loginUser.getId());
			}
			
			String[] companyNameList = request.getParameterValues("companyName");
			String[] companyAddressList= request.getParameterValues("companyAddress");
			String[] postList = request.getParameterValues("post");
			String[] departmentList = request.getParameterValues("department");
			String[] workContentList = request.getParameterValues("workContent");
			String[] startDateList = request.getParameterValues("startDate");
			String[] endDateList = request.getParameterValues("endDate");
			String[] experienceIds= request.getParameterValues("experienceIds");
			
			System.out.println("experienceIds:"+experienceIds.length);
			System.out.println("companyNameList:"+companyNameList.length);
			SecurityPerson dbPerson = personService.findById(id);
			int index = 0;
			for (String experienceId : experienceIds) {
				SecurityPersonExperience securityPersonExperience = new SecurityPersonExperience();
				if(StringUtil.isNotEmpty(experienceId)) {
					securityPersonExperience.setId(Long.parseLong(experienceId));
				}else {
					securityPersonExperience.setCanDel(true);
					securityPersonExperience.setPersonId(id);
					securityPersonExperience.setActive(true);
					securityPersonExperience.setCompanyId(company.getId());
					securityPersonExperience.setIdNum(dbPerson.getIdNumber());
					securityPersonExperience.setOrgId(dbPerson.getRelation().getOrg().getId());
				}
				securityPersonExperience.setCompanyAddress(companyAddressList[index]);
				securityPersonExperience.setCompanyName(companyNameList[index]);
				securityPersonExperience.setDepartment(departmentList[index]);
				securityPersonExperience.setEndDate(endDateList[index]);
				securityPersonExperience.setPost(postList[index]);
				securityPersonExperience.setStartDate(startDateList[index]);
				securityPersonExperience.setWorkContent(workContentList[index]);
				securityPersonExperienceService.saveOrUpdate(securityPersonExperience);
				index++;
			}
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Long experienceId)throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			SecurityPersonExperience dbSecurityPersonExperience = securityPersonExperienceService.findById(experienceId);
			securityPersonExperienceService.delete(dbSecurityPersonExperience);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("findByPersonId")
	public @ResponseBody AjaxResult findByPersonId(Long personId)throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			List<SecurityPersonExperience> personExperienceList = securityPersonExperienceService.findByPersonId(personId);
			result.setSuccessful(true);
			result.setData(personExperienceList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("findByIdNum")
	public @ResponseBody AjaxResult findByIdNum(String idNum)throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			List<SecurityPersonExperience> personExperienceList = securityPersonExperienceService.findByIdNum(idNum);
			result.setSuccessful(true);
			result.setData(personExperienceList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
