package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.page.PersonDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.report.PersonReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskPerson;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.rest.util.NativeUtil;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.task.TaskService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.*;

@Controller
@RequestMapping("person")
public class SecurityPersonController {

    private static final Logger logger = LoggerFactory.getLogger(SecurityPersonController.class);

    @Autowired
    private SecurityPersonService personService;

    @Autowired
    private ArsRestUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private TaskService taskService;

    @Autowired
    private LoginLogService loginLogService;

    @Autowired
    private SecurityCompanyService companyService;


    @Autowired
    private SecurityCompanyPersonService securityCompanyPersonService;
    @Autowired
    private UserRoleService userRoleService;

    @Autowired
    private SecurityPersonExperienceService securityPersonExperienceService;



    @Value("${person-download-folder}")
    private String downloadFolder;

    @Value("${base-folder}")
    private String baseFolder;

    /**
     * 保安员一键搜功能
     *
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("search")
//	@RequiresPermissions("search:read")
    public @ResponseBody
    AjaxResult search(PersonSearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            Long userid = user.getId();
            if (user.getPlatform() == 1) {
                String useridString = request.getParameter("userid");
                if (StringUtil.isNotEmpty(useridString)) {
                    userid = Long.parseLong(useridString);
                    SecurityCompany company = companyService.findByUserid(userid);
                    dto.setCompanyId(company.getId());
                }
            }

            if (dto.getLevels() != null && dto.getLevels().length > 0) {
                for (String level : dto.getLevels()) {
                    if (level.equals("无证人员") || level.equals("保安员资格证")) {
                        dto.setProfessionLevel(level);
                        dto.setLevels(null);
                        break;
                    }
                }
            }

            PersonSearchDto data = personService.search(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 地图保安员一键搜功能
     *
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("searchForMap")
//	@RequiresPermissions("search:read")
    public @ResponseBody
    AjaxResult searchForMap(PersonSearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            Long userid = user.getId();
            if (user.getPlatform() == 1) {
                String useridString = request.getParameter("userid");
                if (StringUtil.isNotEmpty(useridString)) {
                    userid = Long.parseLong(useridString);
                    SecurityCompany company = companyService.findByUserid(userid);
                    dto.setCompanyId(company.getId());
                }
            }

            if (dto.getLevels() != null && dto.getLevels().length > 0) {
                for (String level : dto.getLevels()) {
                    if (level.equals("无证人员") || level.equals("保安员资格证")) {
                        dto.setProfessionLevel(level);
                        dto.setLevels(null);
                        break;
                    }
                }
            }

            PersonSearchDto data = personService.searchForMap(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("/searchPersonList_table")
    @RequiresPermissions("personInfoManager:query")
    @ResponseBody
    public Object searchPersonList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                         HttpServletRequest req, HttpServletResponse resp) {

        try {
            Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
            User user = arsUtil.getCurrentUser();
            Long userid = user.getId();
            if (user.getPlatform() == 1) {
                String useridString = req.getParameter("userid");
                if (StringUtil.isNotEmpty(useridString)) {
                    userid = Long.parseLong(useridString);
                    SecurityCompany company = companyService.findByUserid(userid);
                    p.put("companyid", company.getId());
                }
            }

            CTLUtil.out(personService.searchPersonList_table(p), resp);//进行查询，并转换
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return null;
    }

    @RequestMapping("/personTable")
    @ResponseBody
    public Object queryTable(@RequestParam Map<Object, Object> params, ModelMap model,
                             HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化

        if (p.get("areaCode") != null && StringUtil.isNotEmpty(p.get("areaCode").toString())) {
            String areacode = p.get("areaCode").toString();
            if (areacode.endsWith("0000")) {//省
                p.put("areaCode", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("areaCode", areacode.substring(0, 4) + "__");
            }
        }
        User user = arsUtil.getCurrentUser();
        p.put("userid", user.getId());
        p.put("path", user.getPolice().getPath());

//		String allCount = String.valueOf(personService.getInitCount(p));
        JSONObject json = new JSONObject();
        json.put("data",personService.getInitCount(p));
        json.put("levelCount", personService.queryLevelCnt(p));
        return json;
    }

    @RequestMapping("/personList_table")
    @ResponseBody
    public Object query(@RequestParam Map<Object, Object> params, ModelMap model,
                        HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化

        if (p.get("areaCode") != null && StringUtil.isNotEmpty(p.get("areaCode").toString())) {
            String areacode = p.get("areaCode").toString();
            if (areacode.endsWith("0000")) {//省
                p.put("areaCode", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("areaCode", areacode.substring(0, 4) + "__");
            }
        }
        User user = arsUtil.getCurrentUser();
        p.put("userid", user.getId());
        p.put("path", user.getPolice().getPath());


        CTLUtil.out(personService.querySercurityPersonList(p), resp);//进行查询，并转换
        return null;
    }

    /**
     * 保安员一键搜功能
     *
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("searchForManage")
//	@RequiresPermissions("search:read")
    public @ResponseBody
    AjaxResult searchForManage(PersonSearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            Long userid = user.getId();
            if (user.getPlatform() == 1) {
                String useridString = request.getParameter("userid");
                if (StringUtil.isNotEmpty(useridString)) {
                    userid = Long.parseLong(useridString);
                    SecurityCompany company = companyService.findByUserid(userid);
                    dto.setCompanyId(company.getId());
                }
            }

            if (dto.getLevels() != null && dto.getLevels().length > 0) {
                for (String level : dto.getLevels()) {
                    if (level.equals("无证人员") || level.equals("保安员资格证")) {
                        dto.setProfessionLevel(level);
                        dto.setLevels(null);
                        break;
                    }
                }
            }

            PersonSearchDto data = personService.searchForManage(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员一键搜功能
     *
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("searchForTrain")
//	@RequiresPermissions("search:read")
    public @ResponseBody
    AjaxResult searchForTrain(PersonSearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
//			User user = arsUtil.getCurrentUser();
//			if(user.getPlatform() != 2){
//				throw new ArsException("非公司无法使用此功能！");
//			}
            List<SecurityPerson> data = personService.searchForTrain(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }



    /**
     * 获取指定保安员明细
     * @param request
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody  AjaxResult findById(@PathVariable("id") Long id, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            //获取人员信息
            SecurityPerson person = personService.findById(id);
            //返回人员信息对象
            SecurityPerson resultPerson =new SecurityPerson();
            //身份证号
            resultPerson.setIdNumber(person.getIdNumber());
            resultPerson.setId(id);
            //根据身份证查询人员信息
            resultPerson = personService.find(resultPerson);
            //定义人员与公司的关系
            SecurityCompanyPerson securityCompanyPerson = new SecurityCompanyPerson();
            //判断是否为离职人员，person.getRelation()为空为离职人员
            if(person.getRelation()!=null) {//在职人员
                securityCompanyPerson.setCompany(person.getRelation().getCompany());
                securityCompanyPerson.setOrg(person.getRelation().getOrg());
            }else{//离职人员
                securityCompanyPerson.setCompany(new SecurityCompany());
                securityCompanyPerson.setOrg(new Organization());
            }
            //设置返回结果人员与公司的关系
            resultPerson.setRelation(securityCompanyPerson);
            if (resultPerson != null) {
                User user = arsUtil.getCurrentUser();
                //取消保险信息
                /*if (resultPerson.getInsured()) {
                    //TODO
                    Map<String, Object> map = new HashMap<String, Object>();
                    map.put("order_id", person.getBxOrderno());
                    //保存保险信息
                    String url = ThirdPartyURL.BAILIANBAO + "/api/order/policyDal";
                    String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
                    String product_name = messageUtils.getStringValueByKey(resultStr, "product_name");//产品名称
                    String insurance_ame = messageUtils.getStringValueByKey(resultStr, "insurance_ame");//保险公司名称
                    String inception_date = messageUtils.getStringValueByKey(resultStr, "inception_date");//生效日期
                    String planned_end_date = messageUtils.getStringValueByKey(resultStr, "planned_end_date");//失效日期
                    String gross_premium = messageUtils.getStringValueByKey(resultStr, "gross_premium");//保费
                    String applicant_name = messageUtils.getStringValueByKey(resultStr, "applicant_name");//投保人名称
                    String ins_count = messageUtils.getStringValueByKey(resultStr, "ins_count");//被保险人数量

                    resultPerson.setProduct_name(product_name);
                    resultPerson.setInsurance_ame(insurance_ame);
                    resultPerson.setInception_date(inception_date);
                    resultPerson.setPlanned_end_date(planned_end_date);
                    resultPerson.setGross_premium(gross_premium);
                    resultPerson.setApplicant_name(applicant_name);
                    resultPerson.setIns_count(ins_count);
                }*/

                result.setSuccessful(true);
                result.setData(resultPerson);
            } else {
                result.setSuccessful(false);
                result.setMsg("未找到指定人员信息。");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 获取指定保安员明细
     *
     * @param request
     * @return
     */
    @RequestMapping("findByIdGoodThing/{id}")
    public @ResponseBody  AjaxResult findByIdGoodThing(@PathVariable("id") String id, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SecurityPerson person = personService.findByIdCard(id);
            if (person != null) {
                person = personService.findByIdGoodThing(person.getId());
                //不需要查保险信息，有去调百联保接口，内网会报错
                /*if (person.getInsured()) {
                    //TODO
                    Map<String, Object> map = new HashMap<String, Object>();
                    map.put("order_id", person.getBxOrderno());
                    //保存保险信息
                    String url = ThirdPartyURL.BAILIANBAO + "/api/order/policyDal";
                    String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
                    String product_name = messageUtils.getStringValueByKey(resultStr, "product_name");//产品名称
                    String insurance_ame = messageUtils.getStringValueByKey(resultStr, "insurance_ame");//保险公司名称
                    String inception_date = messageUtils.getStringValueByKey(resultStr, "inception_date");//生效日期
                    String planned_end_date = messageUtils.getStringValueByKey(resultStr, "planned_end_date");//失效日期
                    String gross_premium = messageUtils.getStringValueByKey(resultStr, "gross_premium");//保费
                    String applicant_name = messageUtils.getStringValueByKey(resultStr, "applicant_name");//投保人名称
                    String ins_count = messageUtils.getStringValueByKey(resultStr, "ins_count");//被保险人数量

                    person.setProduct_name(product_name);
                    person.setInsurance_ame(insurance_ame);
                    person.setInception_date(inception_date);
                    person.setPlanned_end_date(planned_end_date);
                    person.setGross_premium(gross_premium);
                    person.setApplicant_name(applicant_name);
                    person.setIns_count(ins_count);
                }*/

                result.setSuccessful(true);
                result.setData(person);
            } else {
                result.setSuccessful(false);
                result.setMsg("未找到指定人员信息。");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 获取在线人员及应急人员
     * @return
     */
    @RequestMapping("findOnlineOrUrgentPersons")
    public @ResponseBody
    AjaxResult findOnlineOrUrgentPersons(String latitude, String longitude, Integer scope) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Map<String, List<SecurityPerson>> map = new HashMap<String, List<SecurityPerson>>();
            List<SecurityPerson> urgentperson = personService.findUrgentPersons(latitude, longitude, scope);
            map.put("urgentperson", urgentperson);
            List<SecurityPerson> onlineperson = personService.findOnlinePersons(latitude, longitude, scope);
            map.put("onlineperson", onlineperson);
            result.setSuccessful(true);
            result.setData(map);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 获取指定公司下的保安员列表
     *
     * @param companyId
     * @return
     */
    @RequestMapping("findByCompanyId/{companyId}")
    public @ResponseBody
    AjaxResult findByCompanyId(@PathVariable("companyId") Long companyId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<SecurityPerson> personList = personService.findByCompanyId(companyId);
            result.setSuccessful(true);
            result.setData(personList);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 获取当前保安员明细
     *
     * @param request
     * @return
     */
    @RequestMapping("detail")
    public @ResponseBody
    AjaxResult detail(HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(false);
            result.setMsg("该用户不存在。");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 更新保安员身份证信息
     * @param person 人员信息
     * @return
     */
    @RequestMapping("updateIdNumber")
    public @ResponseBody
    AjaxResult updateIdNumber(SecurityPerson person) throws Exception {
        AjaxResult result = new AjaxResult();
        personService.updateIdNumber(person);
        result.setSuccessful(true);
        return result;
    }
    /**
     * 更新保安员
     * @param person
     * @param request
     * @return
     */
    @RequestMapping("update")
    public @ResponseBody
    AjaxResult update(SecurityPerson person, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        User currentUser = arsUtil.getCurrentUser();
        try {
            Long nativeCode = arsUtil.getCurrentNatvie();
            if (nativeCode == null) {
                person.setNativeCode(nativeCode);
            }
            Boolean isNew = false;
            if(person.getId() == null){
                isNew = true;
            }
            personService.saveOrUpdate(person);
            if(isNew) {
                personService.sendNewUserMessage(person);
            }
            result.setSuccessful(true);
            result.setData(person);

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("checkPersonStatus")
    public @ResponseBody
    AjaxResult checkPersonStatus(String checkValue, HttpServletRequest request) throws Exception {
        try {
            return personService.checkPersonStatus(checkValue);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    /**
     * 更新保安员位置
     *
     * @param person
     * @param request
     * @return
     */
    @RequestMapping("updateLocation")
    public @ResponseBody
    AjaxResult updateLocation(SecurityPerson person, HttpServletRequest request) throws Exception {
        throw new RuntimeException("非本人更新，ID:" + person.getId());
    }

    /**
     * 更新保安员状态
     *
     * @param person
     * @param request
     * @return
     */
    @RequestMapping("updateGuardStatus")
    public @ResponseBody
    AjaxResult updateGuardStatus(SecurityPerson person, HttpServletRequest request) throws Exception {
        throw new RuntimeException("非本人更新，ID:" + person.getId());
    }

    /**
     * 删除保安员
     *
     * @param person
     * @param request
     * @return
     */

    @RequestMapping("delete")
    @Deprecated
    public @ResponseBody
    AjaxResult delete(SecurityPerson person, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            personService.delete(person);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员级别画像
     *
     * @return
     */
    @RequestMapping("findLevelReport")
    public @ResponseBody
    AjaxResult findLevelReport() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<ReportData> list = personService.findLevelReport();
            result.setSuccessful(true);
            result.setData(list);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员年龄画像
     *
     * @return
     */
    @RequestMapping("findAgeReport")
    public @ResponseBody
    AjaxResult findAgeReport() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Map<String, String[]> data = personService.findAgeReport();
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员性别画像
     *
     * @return
     */
    @RequestMapping("findGenderReport")
    public @ResponseBody
    AjaxResult findGenderReport() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<ReportData> list = personService.findGenderReport();
            result.setSuccessful(true);
            result.setData(list);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员祖籍画像
     *
     * @return
     */
    @RequestMapping("findNativeReport")
    public @ResponseBody
    AjaxResult findNativeReport() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Map<String, String[]> data = personService.findNativeReport();
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员能力画像
     *
     * @param id
     * @return
     */
    @RequestMapping("findAbilityReport/{id}")
    public @ResponseBody
    AjaxResult findAbilityReport(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Map<String, String[]> data = personService.findAbilityReport(id);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员任务类型画像
     *
     * @param id
     * @return
     */
    @RequestMapping("findTaskTypeReport/{id}")
    public @ResponseBody
    AjaxResult findTaskTypeReport(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<ReportData> data = personService.findTaskTypeReport(id);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员任务种类画像
     *
     * @param id
     * @return
     */
    @RequestMapping("findTaskCatalogReport/{id}")
    public @ResponseBody
    AjaxResult findTaskCatalogReport(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Map<String, String[]> data = personService.findTaskCatalogReport(id);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员任务级别画像
     *
     * @param id
     * @return
     */
    @RequestMapping("findTaskLevelReport/{id}")
    public @ResponseBody
    AjaxResult findTaskLevelReport(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<ReportData> data = personService.findTaskLevelReport(id);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    public static void main(String[] args) {
        double a = Double.parseDouble("0.23");
        DecimalFormat df = new DecimalFormat("#.0");
        System.out.println(df.format(a).toString());
    }


    /**
     * 保安员课程学习统计画像  -- liumd 0411
     *
     * @param dto
     * @return
     */
    @RequestMapping("findPersonStudyReport")
    public @ResponseBody
    AjaxResult findPersonStudyReport(PersonStudySearchDTO dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {

            SecurityPerson person = personService.findById(dto.getPersonid());
            dto.setCompanyid(person.getRelation().getCompany().getId());
            //获取当前员工的学习时长  用于返回页面展示图表
            PersonStudyDTO data = personService.findPersonStudyReport(dto);
            dto.setPaging(false);
            if (data != null && data.getPersonid() != null && data.getStudylong() != null && data.getStudylong() > 0) {
                List<PersonStudyDTO> reportDatas = personService.getStudyListDesc(dto);
                Long count = 0l;

                for (PersonStudyDTO personStudyReportData : reportDatas) {
                    if (personStudyReportData.getPersonid() != data.getPersonid()) {
                        if (personStudyReportData.getStudyprogress() < data.getStudyprogress()) {
                            count++;
                        }
                    }
                }
                data.setRate(count * 100 / reportDatas.size() + "%");

                if (StringUtil.isNotEmpty(data.getTrainType())) {
                    String[] trainTypes = data.getTrainType().split("#");
                    if (!trainTypes[0].equals(trainTypes[01])) {
                        StringBuffer studyType = new StringBuffer("正在学习课程：");
                        if (trainTypes[0].equals("1")) {
                            studyType.append("初级保安员培训");
                        } else if (trainTypes[0].equals("2")) {
                            studyType.append("继续再教育");
                        }
                        if (trainTypes[1].equals("1")) {
                            studyType.append("、初级保安员培训");
                        } else if (trainTypes[1].equals("2")) {
                            studyType.append("、继续再教育");
                        }
                        data.setTrainType(studyType.toString());
                    } else {
                        if (trainTypes[0].equals("1")) {
                            data.setTrainType("正在学习课程：初级保安员培训");
                        } else if (trainTypes[0].equals("2")) {
                            data.setTrainType("正在学习课程：继续再教育");
                        } else {
                            data.setTrainType("正在学习课程：暂无");
                        }
                    }
                }
            } else {
                data = new PersonStudyDTO();
                data.setValue(0L);
                data.setName("0%");
                data.setRate("0%");
                data.setStudylong(0l);
                data.setVideonum(0);
                data.setStudyday(0);
            }
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 获取保安员数量
     *
     * @return
     */
    @RequestMapping("searchAllCount")
    public @ResponseBody
    AjaxResult searchAllCount() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            PersonSearchDto dto = new PersonSearchDto();
            Long count = personService.searchAllCount(dto);
            result.setSuccessful(true);
            result.setData(count);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /***
     * 根据紧急任务查询保安人员信息
     * @param id
     * @return
     */
    @RequestMapping(value = "findAllPersonByTaskId/{id}")
    @Deprecated
    public @ResponseBody
    AjaxResult findAllPersonByTaskId(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setData(null);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;

    }


    /**
     * 保存保安人员与任务关系
     *
     * @return
     */
    @RequestMapping("addTaskPerson")
    @Deprecated
    public @ResponseBody
    AjaxResult addTaskPerson(TaskPerson taskPerson) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 根据任务ID查询保安人员列表
     *
     * @return
     */
    @RequestMapping("findAllByTaskId")
    public @ResponseBody
    AjaxResult findAllByTaskId(Long taskId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Task task = taskService.findById(taskId);
            List<SecurityPerson> personList = new ArrayList<SecurityPerson>();
            List<TaskPerson> taskPersonList = task.getPersonList();
            if (taskPersonList != null && taskPersonList.size() > 0) {
                for (TaskPerson taskPerson :
                        taskPersonList) {
                    personList.add(taskPerson.getPerson());
                }
            }
            result.setData(personList);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据当前保安公司的应急小队人员
     *
     * @return
     */
    @RequestMapping("queryUrgentPersonByCompnyId")
    public @ResponseBody
    AjaxResult queryUrgentPersonByCompnyId() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<UrgentPerson> personList = personService.queryUrgentPersonByCompnyId();
            result.setSuccessful(true);
            result.setData(personList);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 紧急人员搜索功能
     *
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("searchUrgentPerson")
    public @ResponseBody
    AjaxResult urgentPerson(PersonSearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            PersonSearchDto data = personService.searchUrgentPerson(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 批量离职
     *
     * @param personIds
     * @return
     * @author LinQingLin
     * @date 2017年4月10日 下午4:07:12
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("batchDelete")
    public @ResponseBody
    AjaxResult batchDelete(Long[] personIds) throws Exception {
        try {
            return personService.batchDelete(personIds);
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 保全批量减员
     *
     * @param personIds
     * @return
     * @author LinQingLin
     * @date 2017年4月10日 下午4:10:32
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("batchAttrition")
    public @ResponseBody
    AjaxResult batchAttrition(Long[] personIds) throws Exception {
        try {
            return personService.batchAttrition(personIds);
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 保全批量减员
     *
     * @param ids
     * @return
     * @author LinQingLin
     * @date 2017年4月10日 下午4:10:32
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("searchBatch")
    public @ResponseBody
    AjaxResult searchBatch(Long[] ids) throws Exception {
        try {
            return personService.searchBatch(ids);
        } catch (Exception e) {
            throw e;
        }
    }


    private String roundingNum(String num) {
        double a = Double.parseDouble(num);
        DecimalFormat df = new DecimalFormat("#.0");
        String day = df.format(a).toString();
        if (day.startsWith(".")) {
            return "0" + day;
        } else {
            return day;
        }
    }

    /**
     * 批量导出保安人员-生成excel
     *
     * @param dto
     * @param request
     */
    @RequestMapping("createPersonsExcel")
    public @ResponseBody
    AjaxResult exportPersons(PersonPageSearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setPaging(false);
                List<SecurityPerson> data = personService.searchForExport(dto);
                //导出
                if(data.size()>65535){
                    throw new ArsException("导出记录数"+data.size()+"，超过excel最大行数，请过滤查询条件再导出！！");
                }
                if (data != null) {
                    Date now = new Date();
                    String dirDate = DateUtil.systemDate.format(now);
                    File dir = new File(downloadFolder + dirDate);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    String templateName = downloadFolder + dirDate + "/" + (now.getTime() + "_人员列表.xls");
                    File file = new File(templateName);
                    Map<Long, Native> nativeData = (Map<Long, Native>) request.getSession().getServletContext().getAttribute(Constants.NATIVE_DATA);
                    personService.exportPersons(data, file, nativeData);
                    if (file != null) {
                        result.setData(templateName);
                        result.setSuccessful(true);
                    } else {
                        result.setSuccessful(false);
                    }
                } else {
                    result.setSuccessful(false);
                }
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 批量导出保安人员
     *
     * @param templateName
     * @param response
     * @throws Exception
     */
    @RequestMapping("exportPersons")
    public void exportPersons(String templateName, HttpServletResponse response) throws Exception {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            File file = new File(templateName);
            if (file != null) {
                ServletOutputStream out = response.getOutputStream();
                String fileName = new String(file.getName().substring(file.getName().indexOf("_") + 1).getBytes("UTF-8"), "iso-8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                InputStream is = new FileInputStream(file);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                is.close();
                out.flush();
                out.close();
            }
        }
    }

    /**
     * 检查保安人员是否已购买保险
     * <b>Function </b>
     *
     * @param userIds
     * @return
     * @author LinQingLin
     * @date 2017年5月2日 下午7:45:34
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("checkUserPolicy")
    public @ResponseBody
    AjaxResult checkUserPolicy(@RequestParam Long[] userIds) throws Exception {
        try {
            return personService.checkUserPolicy(userIds);
        } catch (Exception e) {
            throw e;
        }
    }

    @RequestMapping("checkUnPolicyByCompany")
    public @ResponseBody
    AjaxResult checkUnPolicyByCompany(HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            result.setSuccessful(true);
            LoginLogSearchDto dto = new LoginLogSearchDto();
            dto.setUsername(currentUser.getUsername());
            dto.setType("1");
            dto.setPageNum(0);
            dto.setNumPerPage(5);
            dto.setLogindate(DateUtil.getCurrentDate(DateUtil.FORMAT2));
            dto = loginLogService.search(dto);
            if (dto.getData() != null && dto.getData().size() > 1) {

            } else {
                SecurityCompany company = companyService.findByUserid(currentUser.getId());
                Long[] personIds = personService.findUnPolicyPersonIdByCompanyId(company.getId());
                if (personIds != null && personIds.length > 0) {
                    result.setSuccessful(false);
                    result.setData(personIds);
                    loginLogService.logIn(request);
                }
            }
            return result;
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 保险增员
     * <b>Function </b>
     *
     * @param personIds
     * @return
     * @throws Exception
     * @author LinQingLin
     * @date 2017年7月6日 下午1:25:09
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("policy/increased")
    @Deprecated
    public @ResponseBody
    AjaxResult policy_increased(Long[] personIds) throws Exception {
        try {
            return personService.policy_increased(personIds);
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 解除合同
     * <b>Function </b>
     *
     * @param personId
     * @return
     * @author LinQingLin
     * @date 2017年5月19日 下午7:51:23
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("relieveHt")
    public @ResponseBody
    AjaxResult relieveHt(Long personId) throws Exception {
        try {
            return personService.relieveHt(personId);
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 劳动合同
     *
     * @param person
     * @param request
     * @return
     */
    @RequestMapping("updateHt")
    public @ResponseBody
    AjaxResult updateHt(SecurityPerson person, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Long nativeCode = arsUtil.getCurrentNatvie();
            if (nativeCode == null) {
                person.setNativeCode(nativeCode);
            }
            personService.saveOrUpdateHt(person);
            result.setSuccessful(true);
            result.setData(person);

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    @RequestMapping("dataStatisticsReport")
    public @ResponseBody
    AjaxResult dataStatisticsReport(ReportDataSearchDto searchDto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            PersonReportData data = personService.dataStatisticsReport(searchDto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 在职保安员列表页面初始化 list
     * 离职保安员列表页面初始化 quitList
     * 超时保安员列表页面初始化 outTimelist
     * @param searchDto
     * @return
     */
    @RequestMapping("{pageName}/index")
    public ModelAndView listIndex(@PathVariable String pageName, PersonPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("sys/person/"+pageName);
        view.addObject("record",searchDto);
        return view;
    }
    /**
     * 频繁跳槽人员
     * @return
     */
    @RequestMapping("frequently/index")
    public ModelAndView frequentlyIndex(PersonPageSearchDto dto){
        ModelAndView view = new ModelAndView("sys/person/frequently");
        view.addObject("record",dto);
        return view;
    }

    /**
     * 保安员详情
     * @param id
     * @param request
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView editIndex(Long id,HttpServletRequest request,Long relationId){
        ModelAndView view = new ModelAndView("sys/person/detail");
        SecurityPerson person = personService.findById(id);
        if(relationId!=null) {
            person.setRelation(securityCompanyPersonService.findById(relationId));
            view.addObject("relationId",relationId);
        }
        view.addObject("person",person);
        if(null!=person&&StringUtil.isNotEmpty(person.getIdNumber())) {
            view.addObject("birthdate", IdNumUtil.getBirthdayByIdCard(person.getIdNumber()));
            view.addObject("nativeName", NativeUtil.getNativeByIdNum(person.getIdNumber(), request));
        }
        view.addObject("experienceList",securityPersonExperienceService.findByPersonIdForPunishAndReward(id));
        return view;
    }

    /**
     * 保安员分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page,HttpServletRequest request){
        personService.searchForPage(dto,page);
        return page;
    }
    /**
     * 保安员分页查询频繁跳槽
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForFrequently")
    @ResponseBody
    public AjaxPageResponse searchForFrequently(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page){
        personService.searchForFrequently(dto,page);
        return page;
    }
    /**
     * 统计在职人数数量
     * @return
     */
    @RequestMapping("countNewOldSystemPerson")
    @ResponseBody
    public AjaxResult countNewOldSystemPerson(PersonPageSearchDto dto){
        AjaxResult result = new AjaxResult();
        try {
            if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                result.setData(personService.countNewOldSystemPerson(dto));
                result.setSuccessful(true);
            }
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            result.setSuccessful(false);
        }
        return  result;
    }
    @RequestMapping("searchPrsonExperiences")
    @ResponseBody
    public AjaxPageResponse searchPrsonExperiences(Long id,Long relationId,AjaxPageResponse<PersonDto> page) {
        try {
            personService.selectExperienceById(id,relationId,page);
            return page;
        }catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }


    /**
     * 临保任务查看 关联人员 页面进入
     * @param searchDto
     * @return
     */
    @RequestMapping("choicePersonList")
    public ModelAndView choicePersonList(PersonPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("sys/person/choicePersonList");
        view.addObject("record",searchDto);
        return view;
    }
}
