package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SecurityGuardWorkSearchDto;
import com.bcxin.ars.model.SecurityGuardWork;
import com.bcxin.ars.service.SecurityGuardWorkService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 保安员工作经历
 * @author subh
 */
@Controller
@RequestMapping("securityGuardWork")
public class SecurityGuardWorkController {
    /***
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(SecurityGuardWorkController.class);
    @Autowired
    private SecurityGuardWorkService securityGuardWorkService;
    /**
     * 保安师工作经历分页查询列表
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("search")
    public @ResponseBody
    AjaxPageResponse search(SecurityGuardWorkSearchDto dto, AjaxPageResponse page){
        try {
            if(dto.getGuardId() != null){
                securityGuardWorkService.search(dto, page);
            }
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    /**
     * 保安师工作经历新增 查询修改入口
     * @param guardId
     * @return
     */
    @RequestMapping("add")
    public ModelAndView add(Long guardId){
        ModelAndView view = new ModelAndView("securityGuard/editWork");
        //保存师ID
        SecurityGuardWork securityGuardWork = new SecurityGuardWork();
        securityGuardWork.setGuardId(guardId);
        view.addObject("record", securityGuardWork);
        return view;
    }


    /**
     * 保安师工作经历新增 查询修改入口
     * @param id
     * @return
     */
    @RequestMapping("edit")
    public ModelAndView edit(Long id){
        ModelAndView view = new ModelAndView("securityGuard/editWork");
        view.addObject("record", securityGuardWorkService.findById(id));
        return view;
    }

    /***
     * 保存
     * @param securityGuardWork
     * @throws Exception
     */
    @RequestMapping("saveOrUpdate")
    public @ResponseBody
    AjaxResult saveOrUpdate(SecurityGuardWork securityGuardWork) {
        AjaxResult result = new AjaxResult();
        try {
            if(securityGuardWork.getId()!=null){
              securityGuardWorkService.update(securityGuardWork);
            }else {
                securityGuardWorkService.save(securityGuardWork);
            }
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /***
     * 删除
     * @param securityGuardWork
     * @throws Exception
     */
    @RequestMapping("del")
    public @ResponseBody
    AjaxResult delete(SecurityGuardWork securityGuardWork) {
        AjaxResult result = new AjaxResult();
        try {
                securityGuardWorkService.del(securityGuardWork);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


}