package com.bcxin.ars.rest;

import com.bcxin.ars.dao.sys.FileTempDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SecurityGuardSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.SecurityGuard;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.FileTemp;
import com.bcxin.ars.service.SecurityGuardService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by 王 on 2019/3/18.
 */
@Controller
@RequestMapping("securityGuard")
public class SecurityGuardController {

    private Logger logger = LoggerFactory.getLogger(SecurityGuardController.class);
    @Autowired
    private SecurityGuardService securityGuardService;
    @Value("${temp-folder}")
    private String tempfolder;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private FileTempDao fileTempDao;

    /**
     * 保安师管理页面入口
     * @return
     */
    @RequestMapping("index")
    public ModelAndView index(SecurityGuardSearchDto searchDto){
        ModelAndView view = new ModelAndView("securityGuard/list");
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 保安师分页查询列表
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("search")
    @RequiresPermissions("guardInfoManager:query")
    public @ResponseBody
    AjaxPageResponse search(SecurityGuardSearchDto dto, AjaxPageResponse page){
        try {
            securityGuardService.search(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }


    /**
     * 保安师新增 查询修改入口
     * @param id
     * @return
     */
    @RequestMapping("edit")
    public ModelAndView edit(@RequestParam(required = false) Long id){
        ModelAndView view = new ModelAndView("securityGuard/edit");
        if(id != null) {
            view.addObject("securityGuard", securityGuardService.findById(id));
        }
        return view;
    }


    @RequestMapping("saveOrUpdate")
    public @ResponseBody
    AjaxResult saveOrUpdate(SecurityGuard securityGuard) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                result = securityGuardService.saveOrUpdate(securityGuard);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据ID获取保安师明细
     *
     * @return
     */
    @RequestMapping("findById")
    public @ResponseBody
    AjaxResult findById(Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SecurityGuard securityGuard = securityGuardService.findById(id);
            result.setSuccessful(true);
            result.setData(securityGuard);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 批量导入保安师 by jc 2019-03-26
     */
    @RequestMapping("importSecurityGuardData")
    @RequiresPermissions("guardInfoManager:import")
    public @ResponseBody
    AjaxResult importSecurityGuardData(MultipartFile file, HttpServletRequest request)
            throws Exception {
        AjaxResult result = new AjaxResult();
        String fileType = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        if (!fileType.toUpperCase().equalsIgnoreCase("XLS") && !fileType.toUpperCase().equalsIgnoreCase("XLSX")) {
            result.setMsg("导入的模板文件有误");
            result.setSuccessful(false);
            return result;
        }
        long startTime = System.currentTimeMillis();
        try {
            Date now = new Date();
            String fileName = now.getTime() + "." + fileType;
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(tempfolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = tempfolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行保安师文件上传..." + targetFile);
            file.transferTo(targetFile);
            Map<String, Object> resultMap = new HashMap<String, Object>();
            User loginUser = arsUtil.getCurrentUser();
            List<Map<String, String>> list = new ArrayList<Map<String, String>>(); // 数据库校验的list
            List<Map<String, String>> faildList = new ArrayList<Map<String, String>>(); // 定义失败的list
            if (loginUser != null) {

                FileInputStream inStream = new FileInputStream(targetFile);
                Workbook workBook = WorkbookFactory.create(inStream);
                Sheet sheet = workBook.getSheetAt(0); // 读取第一个sheet
                boolean flag = true;
                int i = 5; // 设置初始行为第6行
                while (flag) {
                    Row row = sheet.getRow(i);
                    if (row != null) {
                        Map<String, String> data = new HashMap<String, String>();
                        try {
                            /*** 客户的数据格式及其复杂
                             *
                             * 1.英文的空格  2.中文的空格  3.非美式英文的半角空格  4.一个tab键  5 .2个tab键
                             * 不过tab键在java可以按英文空格处理，如果在数据库判断长度就非常长了
                             * 现有校验按 1-2-3
                             */
                            String errorMsg = ""; // 校验错误信息
                            /**** 身份证 ****/
                            String idNum = ExcelUtil.getCellValue(row.getCell(0));
                            idNum = idNum.trim().toUpperCase().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            data.put("idNum", idNum);

                            /**** 姓名 ****/
                            String name = ExcelUtil.getCellValue(row.getCell(1));
                            name = name.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "").replaceAll("	", "");
                            data.put("name", name);

                            /**** 性别 ****/
                            String sex = ExcelUtil.getCellValue(row.getCell(2));
                            if (StringUtil.isNotEmpty(sex)) {
                                sex = sex.trim();
                            }
                            data.put("sex_complete", sex);
                            /**** 职业 ****/
                            String profession = ExcelUtil.getCellValue(row.getCell(3));
                            data.put("profession_complete", profession);
                            /**** 级别 ****/
                            String professionLevel = ExcelUtil.getCellValue(row.getCell(4));
                            if (StringUtil.isNotEmpty(professionLevel)) {
                                professionLevel = professionLevel.trim();
                            }

                            data.put("professionLevel_complete", professionLevel);
                            /**** 文化程度 ****/
                            String edu = ExcelUtil.getCellValue(row.getCell(5));
                            if (StringUtil.isNotEmpty(edu)) {
                                edu = edu.trim();
                            }
                            data.put("edu_complete", edu);

                            /**** 联系电话 ****/
                            String phone = ExcelUtil.getCellValue(row.getCell(6));
                            phone = phone.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            data.put("phone", phone);

                            /**** 证书编号 ****/
                            String credential = ExcelUtil.getCellValue(row.getCell(7));
                            if (StringUtil.isNotEmpty(credential)) {
                                credential = credential.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            } else {
                                credential = null;
                            }

                            /**** 颁证日期 ****/
                            String certificatejgtime = ExcelUtil.getCellValue(row.getCell(8));
                            if (StringUtil.isNotEmpty(certificatejgtime)) {
                                certificatejgtime = certificatejgtime.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            } else {
                                certificatejgtime = null;
                            }
                            data.put("certificatejgtime", certificatejgtime);

                            /**** 服务安保公司 ****/
                            String securityCompany = ExcelUtil.getCellValue(row.getCell(9));
                            securityCompany = securityCompany.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            data.put("security_company", securityCompany);
                            data.put("securityCompany", securityCompany);

                            /**** 服务开始时间 ****/
                            String serviceStartTime = ExcelUtil.getCellValue(row.getCell(10));
                            serviceStartTime = serviceStartTime.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            data.put("serviceStartTime", serviceStartTime);

                            /**** 服务结束时间 ****/
                            String serviceEndTime = ExcelUtil.getCellValue(row.getCell(11));
                            serviceEndTime = serviceEndTime.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            data.put("serviceEndTime", serviceEndTime);

                            /**** 培训机构 ****/
                            String trainName = ExcelUtil.getCellValue(row.getCell(12));
                            trainName = trainName.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            data.put("trainName", trainName);

                            /***** 校验excel字段 ****/

                            /*** 身份证号码 ****/
                            if (StringUtil.isEmpty(idNum)) {
                                errorMsg = errorMsg + "身份证号码不能为空";
                            } else {
                                IdcardValidator idcardValidator = new IdcardValidator();
                                if (!idcardValidator.isValidatedAllIdcard(idNum)) {
                                    errorMsg = errorMsg
                                            + (StringUtil.isEmpty(errorMsg) ? "身份证号码格式错误" : " || " + "身份证号码格式错误");
                                }
                            }
                            /*** 姓名 ****/
                            if (StringUtil.isEmpty(name)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "姓名不能为空" : " || " + "姓名不能为空");
                            }
                            /*** 手机号 ****/
                            if (StringUtil.isEmpty(phone)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "联系电话不能为空" : " || " + "联系电话不能为空");
                            }else {
                                if (!PhoneValidator.isPhone(phone)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "联系电话格式错误" : " || " + "联系电话格式错误");
                                }
                            }

                            /*** 性别 ****/
                            if (StringUtil.isEmpty(sex)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "性别不能为空" : " || " + "性别不能为空");
                            } else {
                                sex = sex.substring(0, 1);
                                if (!sex.equalsIgnoreCase(Constants.SEX_BOY)
                                        && !sex.equalsIgnoreCase(Constants.SEX_GIRL)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "性别无效" : " || " + "性别无效");
                                }
                                data.put("sex", sex);
                            }

                            /*** 职业 ****/
                            if (StringUtil.isEmpty(profession)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "职业不能为空" : " || " + "职业不能为空");
                            }else{
                                profession = profession.substring(0, 1);
                                if (!profession.equalsIgnoreCase(Constants.SEX_BOY)
                                        && !profession.equalsIgnoreCase(Constants.SEX_GIRL)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "职业无效" : " || " + "职业无效");
                                }
                                data.put("profession", profession);
                            }

                            /*** 级别 ****/
                            if (StringUtil.isEmpty(professionLevel)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "级别不能为空" : " || " + "级别不能为空");
                            } else {
                                professionLevel = professionLevel.substring(0, 1);
                                if (!professionLevel.equalsIgnoreCase(Constants.PROFESSION_LEVEL_ONE)
                                        && !professionLevel.equalsIgnoreCase(Constants.PROFESSION_LEVEL_TWO)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "级别无效" : " || " + "级别无效");
                                }
                                data.put("professionLevel", professionLevel);
                            }

                            /*** 文化程度 ****/
                            if (StringUtil.isEmpty(edu)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "文化程度不能为空" : " || " + "文化程度不能为空");
                            } else {
                                edu = edu.substring(0, 1);
                                data.put("edu", edu);
                            }

                            /*** 培训机构 ****/
                            if (StringUtil.isEmpty(trainName)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "培训机构不能为空" : " || " + "培训机构不能为空");
                            } else {
                                data.put("trainName", trainName);
                            }

                            /*** 校验证书编号 ****/
                            if (StringUtil.isNotEmpty(credential)) {
                                if (credential.length() > 16) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "证书编号格式错误" : " || " + "证书编号格式错误");
                                } else {
                                    /*** 因为客户之前的excel文件证书编号可能存在科学计数法***/
                                    if (credential.contains("E") && credential.contains(".")) {
                                        BigDecimal bd = new BigDecimal(credential);
                                        credential = bd.toPlainString();
                                        data.put("credential", credential);
                                    }
                                }
                            }
                            data.put("credential", credential);

                            /*** 校验日期 ****/
                            if (StringUtil.isNotEmpty(certificatejgtime)) {
                                /*** 校验日期合法性 ****/
                                if (!DateUtil.checkDate(certificatejgtime)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "颁证日期无效" : " || " + "颁证日期无效");
                                } else {
                                    /*** 校验日期不能大于当前日期 ****/
                                    if (!DateUtil.dateCompare(certificatejgtime, DateUtil.getCurrentDate(DateUtil.DATEFORMAT))) {
                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "颁证日期不能大于当前日期"
                                                : " || " + "颁证日期不能大于当前日期");
                                    }

                                }
                            }
                            if (StringUtil.isNotEmpty(serviceStartTime)) {
                                /*** 校验日期合法性 ****/
                                if (!DateUtil.checkDate(serviceStartTime)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "服务开始时间无效" : " || " + "服务开始时间无效");
                                }
                            }
                            if (StringUtil.isNotEmpty(serviceEndTime)) {
                                /*** 校验日期合法性 ****/
                                if (!DateUtil.checkDate(serviceEndTime)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "服务结束时间无效" : " || " + "服务结束时间无效");
                                } else {
                                    if (StringUtil.isNotEmpty(serviceStartTime)) {
                                        if (DateUtil.checkDate(serviceStartTime)) {
                                            /*** 校验日期不能大于当前日期 ****/
                                            if (!DateUtil.dateCompare(serviceStartTime,serviceEndTime)) {
                                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "服务结束时间不能小于服务开始时间"
                                                        : " || " + "服务结束时间不能小于服务开始时间");
                                            }
                                        }
                                    }
                                }
                            }else {
                                if(StringUtil.isNotEmpty(serviceStartTime)){
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "请填入服务结束时间" : " || " + "请填入服务结束时间");
                                }
                            }
                            // 生成错误的list
                            if (StringUtil.isNotEmpty(errorMsg)) {
                                data.put("errorMsg", errorMsg);
                                faildList.add(data);
                            } else {
                                list.add(data);
                            }

                        } catch (Exception e) {
                            if (e instanceof ArsException) {
                                data.put("errorMsg", e.getMessage());
                            } else {
                                data.put("errorMsg", "格式有错");
                            }
                            faildList.add(data);
                        }
                    } else {
                        flag = false;
                    }
                    i++;
                }

                /** 如果客户没上传内容 **/
                if (list.size() == 0 && faildList.size() == 0) {
                    result.setMsg("导入模板没有保安师信息，请录入");
                    result.setSuccessful(false);
                    return result;
                }

                /**** 处理保安师业务逻辑 ***/
                List<Map<String, String>> checkFaildList = new ArrayList<>();
                if (list != null && list.size() > 0) {
                    //处理业务逻辑
                    checkFaildList = securityGuardService.saveSecurityGuard(list, loginUser);
                }
                long endTime = System.currentTimeMillis();
                logger.info("耗费时间： " + (endTime - startTime) + " ms");

                /**** 如果校验的保安师信息有误 ****/
                if (checkFaildList != null && checkFaildList.size() > 0) {
                    faildList.addAll(checkFaildList);
                }

                /**** 如果存在校验错误信息，导出excel表格 ****/
                if (faildList.size() > 0) {
                    String excelTmepName = "securityGuardFailTemp.xls"; // excel模板
                    FileTemp fileTemp = fileTempDao.getFileTempByName(excelTmepName); // 查询文件模板信息
                    // resultMap.put("faildFilePath",
                    // buildFaildList(fileTemp.getPath(), faildList,request));
                    // // 生成导入错误的文件,// 绝对路径文件实现
                    resultMap.put("faildFilePath",
                            buildFaildList(Constants.FILETEMPPATH + fileTemp.getFileTempName(), faildList, request)); // 生成导入错误的文件
                }
            } else {
                throw new RuntimeException("当前登录信息错误, user:" + loginUser);
            }
            result.setData(resultMap);
            if (faildList.size() == 0) {
                result.setMsg("批量导入成功");
            } else {
                result.setMsg(faildList.size() + "人导入失败，请下载导入失败的保安师人员信息");
            }
            targetFile.delete(); // 导入成功完删除文件
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 生成导入错误信息文件
     *
     * @param excelTempPath
     * @param data
     * @return downloadFilePath by llc 2018-08-09
     * @throws Exception
     */
    private String buildFaildList(String excelTempPath, List<Map<String, String>> data, HttpServletRequest request)
            throws Exception {

        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(tempfolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = now.getTime() + "_importFailList.xls";
        String filePath = tempfolder + dirDate + "/" + fileName;
        String fileKey = "temp/" + dirDate + "/" + fileName;
        logger.info("路径： " + filePath);
        /**** 生成file ****/
        // FileUtil.reNameFile(excelTempPath,filePath); // 绝对路径文件实现

        reNameFile(excelTempPath, filePath, request);
        File file = new File(filePath);

        if (file != null) {
            HSSFWorkbook workbook = new HSSFWorkbook(new FileInputStream(file));
            HSSFSheet sheet = workbook.getSheetAt(0);
            int index = 5;
            for (Map<String, String> map : data) {
                Row row = sheet.createRow(index);
                row.createCell(0).setCellValue(map.get("idNum")); // 身份证
                row.createCell(1).setCellValue(map.get("name")); // 姓名
                row.createCell(2).setCellValue(map.get("sex_complete")); // 性别
                row.createCell(3).setCellValue(map.get("profession_complete")); // 职业
                row.createCell(4).setCellValue(map.get("professionLevel_complete")); // 级别
                row.createCell(5).setCellValue(map.get("edu_complete")); // 文化程度
                row.createCell(6).setCellValue(map.get("phone")); // 联系电话
                row.createCell(7).setCellValue(map.get("credential")); // 证书编号
                row.createCell(8).setCellValue(map.get("certificatejgtime")); // 颁证日期
                row.createCell(9).setCellValue(map.get("security_company")); // 服务安保公司
                row.createCell(10).setCellValue(map.get("serviceStartTime")); // 服务开始时间
                row.createCell(11).setCellValue(map.get("serviceEndTime")); // 服务结束时间
                row.createCell(12).setCellValue(map.get("trainName")); // 培训机构
                row.createCell(13).setCellValue(map.get("errorMsg")); // 错误信息
                index++;
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            workbook.write(fileOut);
            fileOut.close();
            workbook.close();
            return "/getResource.do?path=" + fileKey;
        }
        return null;
    }

    /**
     * 重命名文件
     *
     * @param oldPath String 原文件路径 如：原文件路径
     *                如：c:/data/ars/temp/securityCertificateTemp.xls
     * @param newPath String 复制后路径 如：复制后路径 如：c:/data/ars/temp/2018-08-09/保安员导入失败.xls
     * @return boolean by llc 2018-08-09
     **/
    private static void reNameFile(String oldPath, String newPath, HttpServletRequest request) throws IOException {
        InputStream is = null;
        OutputStream out = null;
        try {
            is = request.getServletContext().getResourceAsStream(oldPath);
            int bytesum = 0;
            int byteread = 0;
            if (is != null) { // 文件存在时
                out = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                int length;
                while ((byteread = is.read(buffer)) != -1) {
                    bytesum += byteread; // 字节数 文件大小
                    out.write(buffer, 0, byteread);
                }
                is.close(); // 输入流关闭
                out.flush(); // 刷新输出流
                out.close(); // 输出流关闭
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        } finally { // 无论程序怎么运行，最后都要关闭流；
            if (is != null || out != null) {
                try {
                    is.close();// 输入流关闭
                    out.close(); // 输出流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}