package com.bcxin.ars.rest;


import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SecurityGoodThingDetailDTO;
import com.bcxin.ars.dto.SecurityGoodThingDto;
import com.bcxin.ars.model.SecurityGoodThing;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SecurityGoodThingService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.util.CTLUtil;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;


/**
 * 保安員好人好事要闻
 * @author harve
 */
@Controller
@RequestMapping("securitygoodthing")
public class SecurityGoodThingController {

    private Logger logger = LoggerFactory.getLogger(SecurityGoodThingController.class);

    @Autowired
    private SecurityGoodThingService securityGoodThingService;

    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ArsRestUtil arsUtil;

    @Value("${securitygoodthing-download-folder}")
    private String downloadFolder;
    /**
     * 查询全部保安员好人好事要闻
     * @param dto
     * @return
     */
    @RequestMapping("findAll")
    public @ResponseBody
    AjaxResult findAll(SecurityGoodThingDto dto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                if (user.getPlatform() == 2) {
                    dto.setUserid(user.getId());
                }
            }
            SecurityGoodThingDto data = securityGoodThingService.search(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("/searchSecuritygoodthingList_table")
    @RequiresPermissions("goodThing:query")
    @ResponseBody
    public Object searchSecuritygoodthingList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                                HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        User user = arsUtil.getCurrentUser();
        if(user != null) {
            if (user.getPlatform() == 2) {
                p.put("userid",user.getId());
            }
        }
        CTLUtil.out(securityGoodThingService.searchSecuritygoodthingList_table(p), resp);//进行查询，并转换
        return null;
    }

    /**
     * 查询保安员好人好事要闻
     * 通过id
     * @return
     */
    @RequestMapping("findById")
    @RequiresPermissions("goodThing:view")
    public @ResponseBody
    AjaxResult findById(SecurityGoodThing securityGoodThing) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SecurityGoodThing securityGoodThing1 = securityGoodThingService.findById(securityGoodThing.getId());
            result.setSuccessful(true);
            result.setData(securityGoodThing1);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 查询保安员好人好事要闻
     * 通过id
     * @return
     */
    @RequestMapping("findByIdForPerson")
    public @ResponseBody
    AjaxResult findByIdForPerson(Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SecurityGoodThingDetailDTO securityGoodThing = securityGoodThingService.findByIdForPerson(id);
            result.setSuccessful(true);
            result.setData(securityGoodThing);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 更新保安员好人好事要闻
     * 通过id
     * @return
     */
    @RequestMapping("updateById")
    public @ResponseBody
    AjaxResult UpdateById(SecurityGoodThing securityGoodThing) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SecurityGoodThing securityGoodThing1 = securityGoodThingService.updateById(securityGoodThing);
            result.setSuccessful(true);
            result.setData(securityGoodThing1);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 更新保安员好人好事要闻
     * 通过id
     * @return
     */
    @RequestMapping("deleteById")
    public @ResponseBody
    AjaxResult DeleteById(SecurityGoodThing securityGoodThing) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result = securityGoodThingService.deleteGoodThing(securityGoodThing.getId());
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 新增好人好事要闻
     * @param securityGoodThing
     * @return
     */
    @RequestMapping("add")
    public @ResponseBody
    AjaxResult add(SecurityGoodThing securityGoodThing) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            securityGoodThingService.save(securityGoodThing);
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 批量导出保安员证报名列表（仅适用与内网数据导入到外网）
     */
    @RequestMapping("exportData")
    public @ResponseBody
    AjaxResult createCompanysExcel(SecurityGoodThingDto dto, HttpServletRequest request) throws Exception{
        AjaxResult result = new AjaxResult();
        try{
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                dto.setPaging(false);
                SecurityGoodThingDto data = securityGoodThingService.search(dto);
                if(data.getData() != null) {
                    Date now = new Date();
                    String dirDate = DateUtil.systemDate.format(now);
                    File dir = new File(downloadFolder + dirDate);
                    if(!dir.exists()) {
                        dir.mkdirs();
                    }
                    String templateName = downloadFolder + dirDate+"/" + (now.getTime() + "_好人好事列表.xls");
                    File file = new File(templateName);
                    securityGoodThingService.exportSecurityGoodThing(data.getData(), file);
                    result.setData(templateName);
                    result.setSuccessful(true);
                }else{
                    result.setSuccessful(false);
                }
            }
        }catch(Exception e){
            throw e;
        }
        return result;
    }

    /**
     * 批量导出
     * @param templateName
     * @param response
     * @throws Exception
     */
    @RequestMapping("exportSecurityGoodThing")
    public void exportPersons(String templateName, HttpServletResponse response)throws Exception{
        User user = arsUtil.getCurrentUser();
        if(user != null) {
            File file = new File(templateName);
            if(file != null) {
                ServletOutputStream out = response.getOutputStream();
                String fileName = new String(file.getName().substring(file.getName().indexOf("_")+1).getBytes("UTF-8"),"iso-8859-1");
                response.addHeader("Content-Disposition","attachment;filename=" + fileName);
                InputStream is = new FileInputStream(file);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                is.close();
                out.flush();
                out.close();
            }
        }
    }


    /***
     * 好人好事
     * @param dto 好人好事查询参数
     * @return 好人好事列表
     * @throws Exception
     */
    @RequestMapping("query")
    @RequiresPermissions("goodThing:query")
    public @ResponseBody AjaxPageResponse search(SecurityGoodThingDto dto, AjaxPageResponse page){
        try {
            //等级证实习记录查询
            securityGoodThingService.query(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

}
