package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SecurityConfesscompanySearchDto;
import com.bcxin.ars.model.SecurityConfesscompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SecurityConfesscompanyService;
import com.bcxin.ars.util.CTLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;


@Controller
@RequestMapping("securityConfesscompany")
public class SecurityConfesscompanyController {
	
	private static final Logger logger = LoggerFactory.getLogger(SecurityConfesscompanyController.class);
	
	@Autowired
	private SecurityConfesscompanyService securityConfesscompanyService;

	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getSecurityConfesscompanyList")
	public @ResponseBody AjaxResult search(SecurityConfesscompanySearchDto securityConfesscompanySearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(securityConfesscompanySearchDto.getUserid() == null) {
				securityConfesscompanySearchDto.setUserid(user.getId());
			}
			SecurityConfesscompanySearchDto data = securityConfesscompanyService.search(securityConfesscompanySearchDto);
				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

   /**
	 * 查询全部 wjb 2018年9月27日13:20:13
	 * @return
	 */
	@RequestMapping("/searchSecurityConfesscompanyList_table")
	@ResponseBody
	public Object searchSecurityConfesscompanyList_table(@RequestParam Map<Object, Object> params, ModelMap model,
												 HttpServletRequest req, HttpServletResponse resp) {
		Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化

		CTLUtil.out(securityConfesscompanyService.searchSecurityConfesscompanyList_table(p), resp);//进行查询，并转换
		return null;
	}

	/**
	 * 创建或更新保安培训机构信息
	 * @param securityConfesscompany 保安培训机构信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(SecurityConfesscompany securityConfesscompany, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			securityConfesscompanyService.saveOrUpdate(securityConfesscompany);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除保安培训机构信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SecurityConfesscompany securityConfesscompany = securityConfesscompanyService.findById(id);

			if(securityConfesscompany != null) {
				securityConfesscompanyService.delete(securityConfesscompany);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取保安培训机构信息
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SecurityConfesscompany securityConfesscompany = securityConfesscompanyService.findById(id);
			result.setSuccessful(true);
			result.setData(securityConfesscompany);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
