package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SbSubsidiaryBaseSearchDto;
import com.bcxin.ars.model.SbSubsidiaryBase;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SbSubsidiaryBaseService;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;


@Controller
@RequestMapping("sbSubsidiaryBase")
public class SbSubsidiaryBaseController {
	
	private static final Logger logger = LoggerFactory.getLogger(SbSubsidiaryBaseController.class);
	
	@Autowired
	private SbSubsidiaryBaseService sbSubsidiaryBaseService;

	@Autowired
	private ArsRestUtil arsUtil;

	@Autowired
	private SecurityPersonService personService;
	
	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getsbSubsidiaryBaseList")
	public @ResponseBody AjaxResult update(SbSubsidiaryBaseSearchDto sbSubsidiaryBase) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(sbSubsidiaryBase.getUserid() == null) {
				sbSubsidiaryBase.setUserid(user.getId());
			}
			SbSubsidiaryBaseSearchDto data = sbSubsidiaryBaseService.search(sbSubsidiaryBase);
				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新子公司基础信息
	 * @param sbSubsidiaryBase 子公司基础信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(SbSubsidiaryBase sbSubsidiaryBase, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			sbSubsidiaryBaseService.saveOrUpdate(sbSubsidiaryBase);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除子公司基础信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbSubsidiaryBase sbSubsidiaryBase = sbSubsidiaryBaseService.findById(id);

			if(sbSubsidiaryBase != null) {
					sbSubsidiaryBaseService.delete(sbSubsidiaryBase);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取信息明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbSubsidiaryBase sbSubsidiaryBase = sbSubsidiaryBaseService.findById(id);
			result.setSuccessful(true);
			result.setData(sbSubsidiaryBase);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
