package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SbRewardSearchDto;
import com.bcxin.ars.model.SbReward;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SbRewardService;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
/**
 * 保安奖励
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月2日 上午9:42:54
 * @注意事项 </b>
 * <b>
 */

@Controller
@RequestMapping("sbReward")
public class SbRewardController {
	
	private static final Logger logger = LoggerFactory.getLogger(SbRewardController.class);
	
	@Autowired
	private SbRewardService sbRewardService;
	@Autowired
	private SecurityPersonService securityPersonService;
	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getSbRewardList")
	public @ResponseBody AjaxResult search(SbRewardSearchDto sbRewardSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if (user.getPlatform() == 2) {
					sbRewardSearchDto.setUserid(user.getId());
				}
			}
			SbRewardSearchDto data = sbRewardService.search(sbRewardSearchDto);
				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新保安奖励信息
	 * @param sbReward 保安奖励信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(SbReward sbReward, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			sbRewardService.saveOrUpdate(sbReward);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除保安奖励信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbReward sbReward = sbRewardService.findById(id);

			if(sbReward != null) {
				sbRewardService.delete(sbReward);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取保安奖励信息
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbReward sbReward = sbRewardService.findById(id);
			result.setSuccessful(true);
			result.setData(sbReward);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
