package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SbBusinessManagementSearchDto;
import com.bcxin.ars.model.SbBusinessManagement;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SbBusinessManagementService;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * 
 * 跨区经营信息
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月1日 下午4:45:36
 * @注意事项 </b>
 * <b>
 */

@Controller
@RequestMapping("sbBusinessManagement")
public class SbBusinessManagementController {
	
	private static final Logger logger = LoggerFactory.getLogger(SbBusinessManagementController.class);
	
	@Autowired
	private SbBusinessManagementService sbBusinessManagementService;

	@Autowired
	private SecurityPersonService securityPersonService;

	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getSbBusinessManagementList")
	public @ResponseBody AjaxResult getSbBusinessManagementList(SbBusinessManagementSearchDto sbBusinessManagementSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if (user.getPlatform() == 2) {
					sbBusinessManagementSearchDto.setUserid(user.getId());
				}
			}
			SbBusinessManagementSearchDto data = sbBusinessManagementService.search(sbBusinessManagementSearchDto);

				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新跨区经营信息
	 * @param sbBusinessManagement 跨区经营信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(SbBusinessManagement sbBusinessManagement, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			sbBusinessManagementService.saveOrUpdate(sbBusinessManagement);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除跨区经营信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbBusinessManagement sbBusinessManagement = sbBusinessManagementService.findById(id);

			if(sbBusinessManagement != null) {
				sbBusinessManagementService.delete(sbBusinessManagement);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取信息明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbBusinessManagement sbBusinessManagement = sbBusinessManagementService.findById(id);
			result.setSuccessful(true);
			result.setData(sbBusinessManagement);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
