package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Role;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.RoleService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Controller
@RequestMapping("role")
public class RoleController {
	
	private Logger logger = LoggerFactory.getLogger(RoleController.class);

	@Autowired
	private RoleService roleService;
	
	@Autowired
	private SecurityCompanyService companyService;
	
	@Autowired
	private SecurityPersonService personService;

	@Autowired
	private UserService userService;
	
	@Autowired
	private ArsRestUtil arsUtil;
	
	/**
	 * 根据ID获取角色明细
	 * @param id
	 * @param request
	 * @return
	 */
	@RequestMapping("detail/{id}")
	public @ResponseBody AjaxResult detail(@PathVariable("id")Long id, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Role role = roleService.findById(id);
			result.setSuccessful(true);
			result.setData(role);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 获取当前登录安保公司的角色列表
	 * @param request
	 * @return
	 */
	@RequestMapping("getRoleList")
	public @ResponseBody AjaxResult getRoleList(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			SecurityCompany company = null;
			if(user.getPlatform() == 1){
				throw new ArsException("登录信息错误！");
			}
			if(user.getPlatform() == 2){
				company = companyService.findByUserid(user.getId());
			}
			
			List<Role> roleList = roleService.findByCompany(company.getId());
			if(roleList != null && roleList.size() >0){
				result.setSuccessful(true);
				result.setData(roleList);
			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 创建或更新角色
	 * @param role	基本信息
	 * @param request
	 * @return
	 */
	@RequestMapping(value="update", method=RequestMethod.POST)
	public @ResponseBody AjaxResult update(Role role, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			SecurityCompany company = companyService.getCurrentUserCompany();
			if(company != null) {
				role.setCompany(company);
				roleService.saveOrUpdate(role);
				result.setSuccessful(true);
				result.setData(role.getId());
			} else {
				result.setSuccessful(false);
				result.setMsg("当前安保公司信息错误，Userid:" + user.getId());
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 删除角色
	 * @param role	基本信息
	 * @param request
	 * @return
	 */
	@RequestMapping(value="delete", method=RequestMethod.POST)
	public @ResponseBody AjaxResult delete(Role role, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null){
				role.setUpdateBy(user.getUsername());
				roleService.delete(role);
				result.setSuccessful(true);
				result.setData(role);
			} else {
				result.setSuccessful(false);
				result.setMsg("当前用户信息错误");
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("findByUserId")
	public @ResponseBody AjaxResult findByUserId(Long userId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			//获取单位信息
			SecurityCompany company = companyService.getCurrentUserCompany();

			List<Role> roles = roleService.findByUserIdCompanyId(userId,company.getId());
			result.setSuccessful(true);
			result.setData(roles);

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
