package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSycDto;
import com.bcxin.ars.dto.ProblemPersonSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.ProblemPerson;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ProblemPersonService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.webservice.dto.ProblemResult;
import com.bcxin.ars.webservice.util.BJProblemDetailUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.crypto.BadPaddingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("problemperson")
public class ProblemPersonController {

	/***
	 * 日志
	 */
	private static final Logger logger = LoggerFactory.getLogger(ProblemPersonController.class);
	
	@Autowired
	private ProblemPersonService problemPersonService;


	@Autowired
	private SecurityCompanyService companyService;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private BJProblemDetailUtil bjProblemDetailUtil;

	@Value("${temp-folder}")
	private String tempfolder;

	/***
	 * 进入问题人员查询页面
	 * @return 页面路径
	 */
	@RequestMapping("/toListPage")
	@RequiresPermissions("problemPerson:query")
	public ModelAndView toListPage(ProblemPersonSearchDto searchDto,String  func,String param) {
		ModelAndView view = new ModelAndView();
		String personType = "";
		//查询页面地址
		view.setViewName("problemperson/list");
		//查询待处理问题人员
		if(StringUtil.isNotEmpty(func)) {
		    view.addObject("func", func);
		}
        //信息有误
        if("info".equals(param)){
            view.addObject("personType", "1");
            personType = "1";
        }
		//在逃
        if("large".equals(param)){
            view.addObject("personType", "2");
            personType = "2";
        }
        //前科人员 （重点人员）
        if("criminal".equals(param)){
            view.addObject("personType", "3");
            personType = "3";
        }
		//获取问题人员类型
		view.addObject("typeList", problemPersonService.queryProblemType(personType));
		view.addObject("record", searchDto);
		return view;
	}

	/***
	 * 进入问题人员公安处理，企业未处理页面
	 * @return 页面路径
	 */
	@RequestMapping("/toListPageAll")
	@RequiresPermissions("problemPerson:query")
	public ModelAndView toListPageAll(ProblemPersonSearchDto searchDto) {
		ModelAndView view = new ModelAndView();
		String personType = "";
		//查询页面地址
		view.setViewName("problemperson/listenterprise");
		//获取问题人员类型
		view.addObject("typeList", problemPersonService.queryProblemType(personType));
		view.addObject("record", searchDto);
		return view;
	}

	/***
	 * 查询问题人员方法
	 * @param searchDto 查询参数
	 * @param page 返回查询列表
	 * @return 问题人员列表
	 * @throws Exception 异常
	 */
	@RequestMapping("searchall")
	@RequiresPermissions("problemPerson:query")
	public @ResponseBody AjaxPageResponse searchAll(ProblemPersonSearchDto searchDto, AjaxPageResponse page) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			result.setSuccessful(true);
			problemPersonService.searchall(searchDto,page);
		} catch(Exception e) {
			e.printStackTrace();
			logger.error(e.getMessage(), e);
			throw e;
		}
		return page;
	}


	/***
	 * 进入问题人员查询页面
	 * @return 页面路径
	 */
	@RequestMapping("/toCompanyListPage")
	@RequiresPermissions("problemPerson:companyQueryPage")
	public ModelAndView toCompanyListPage() {
		ModelAndView view = new ModelAndView();
        //获取当前用户信息
        User user  = arsUtil.getCurrentUser();
        SecurityCompany company =  companyService.findByUserid(user.getId());
//        //获取问题人员类型
		if(null!=user){
			if(null!=company&&StringUtil.isNotEmpty(String.valueOf(company.getId()))){
				view.addObject("typeList", problemPersonService.queryProblemTypeForCompanyId(company.getId()));
			}
		}
		//查询页面地址
        view.setViewName("problemperson/listcompany");
		return view;
	}
	/***
	 * 查询问题人员方法（用于公司）
	 * @param searchDto 查询参数
	 * @param page 返回查询列表
	 * @return 问题人员列表
	 * @throws Exception 异常
	 */
	@RequestMapping("searchCompany")
	@RequiresPermissions("problemPerson:companyQuery")
	public @ResponseBody AjaxPageResponse searchCompany(ProblemPersonSearchDto searchDto, AjaxPageResponse page) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			result.setSuccessful(true);
			problemPersonService.search(searchDto,page);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return page;
	}

	/***
	 * 进入问题人员处理页面
	 * @return 页面路径
	 */
	@RequestMapping("/toDisposePage")
	@RequiresPermissions("problemPerson:view")
	public ModelAndView toDisposePage(Long id ) {
		ModelAndView view = new ModelAndView();
		//查询页面地址
		view.setViewName("problemperson/dispose");
		ProblemPerson problemPerson =  problemPersonService.findById(id);
		//未抓获默认为0
		if(StringUtil.isEmpty(problemPerson.getCatchState())){
			problemPerson.setCatchState(Constants.CATCHSTATE_NO);
		}
		//在逃人员
        view.addObject("personType", problemPerson.getPersonType());
		view.addObject("problemPerson",problemPerson);
		return view;
	}

	/***
	 * 查询问题人员方法
	 * @param searchDto 查询参数
	 * @param page 返回查询列表
	 * @return 问题人员列表
	 * @throws Exception 异常
	 */
	@RequestMapping("search")
	@RequiresPermissions("problemPerson:query")
	public @ResponseBody AjaxPageResponse search(ProblemPersonSearchDto searchDto, AjaxPageResponse page) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			result.setSuccessful(true);
			problemPersonService.search(searchDto,page);
		} catch(Exception e) {
			e.printStackTrace();
			logger.error(e.getMessage(), e);
			throw e;
		}
		return page;
	}
    /***
     * 公司保安处理意见,外网更新，只更新 ：更新时候、更新标识、单位处理状态、单位处理意见
     * @param problemPerson 问题人员信息
     * @return
     * @throws Exception
     */
    @RequestMapping("saveCompanyDispose")
    @RequiresPermissions("problemPerson:saveCompanyDispose")
    public @ResponseBody AjaxResult saveCompanyDispose(ProblemPerson problemPerson) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            problemPersonService.saveCompanyDispose(problemPerson);
            result.setSuccessful(true);
            return result;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }

    }


    /***
     * 统计告警人员
     * @return
     * @throws Exception
     */
    @RequestMapping("countAlarm")
    public @ResponseBody AjaxResult countAlarm() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setData(problemPersonService.countAlarm());
            result.setSuccessful(true);
            return result;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }

    }
    /***
     * 进入公司问题人员处理页面
     * @return 页面路径
     */
    @RequestMapping("/toCompanyDispose")
    @RequiresPermissions("problemPerson:view")
    public ModelAndView toCompanyDispose(Long id ) {
        ModelAndView view = new ModelAndView();
        //查询页面地址
        view.setViewName("problemperson/companyDispose");
        view.addObject("problemPerson",problemPersonService.findById(id));
        return view;
    }
    /***
	 * 问题人员处理页面保存
	 * @param problemPerson
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("saveDispose")
	@RequiresPermissions("problemPerson:dispose")
	public @ResponseBody AjaxResult saveDispose(ProblemPerson problemPerson) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			problemPersonService.saveDispose(problemPerson);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 批量导入保安员证报名列表（仅适用与内网数据导入到外网）
	 */
	@RequestMapping("importData")
	public @ResponseBody AjaxResult importData(MultipartFile file,HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Date now = new Date();
			String fileName = now.getTime() + "_" + file.getOriginalFilename();
			String dirDate = DateUtil.systemDate.format(now);
			File dir = new File(tempfolder + dirDate);
			if(!dir.exists()) {
				dir.mkdirs();
			}
			String targetPath = tempfolder + dirDate + "/" + fileName;
			File targetFile = new File(targetPath);
			logger.info("执行文件上传..." + targetFile);
			file.transferTo(targetFile);
			
			BufferedReader br = new BufferedReader(new FileReader(targetFile));
			StringBuffer content = new StringBuffer();
			// 获取文件内容
			String lineTxt = null;
			while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
				content.append(lineTxt);
			}
			br.close();

			String jsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));
			
			System.out.println(jsonStr);
			DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);
			
			if(dataSycDto != null) {
				if(dataSycDto.getDataType().equals(Constants.DATASYC_PROBLEMPERSON_LIST)) {
					List<ProblemPerson> personlist = JSONArray.parseArray(dataSycDto.getData(), ProblemPerson.class);
					for (ProblemPerson problemPerson : personlist) {
						problemPersonService.saveOrUpdateForDS(problemPerson);
					}
		            result.setMsg("导入成功");
		            result.setSuccessful(true);
				}else {
		            result.setMsg("导入失败，非问题人员的数据！");
		            result.setSuccessful(false);
				}
			}else {
				result.setMsg("导入失败，非问题人员的数据！");
	            result.setSuccessful(false);
			}
			
            Map<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("faildFilePath", "");
            result.setData(resultMap);
		} catch (BadPaddingException badPaddingException){
			logger.error(badPaddingException.getMessage(), badPaddingException);
			throw new ArsException("导入失败，非该区域数据\n！");
		}catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

	/**
	 * 批量导出保安员证报名列表（仅适用与内网数据导入到外网）
	 */
	@RequestMapping("exportData")
	public void exportData(HttpServletRequest request,HttpServletResponse response) throws Exception {
		try{
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				DataSycDto dataSycDto = new DataSycDto();
				dataSycDto.setDataType(Constants.DATASYC_PROBLEMPERSON_LIST);
				List<ProblemPerson> personlist = problemPersonService.findProblemPersonList();
				dataSycDto.setData(JSONObject.toJSONString(personlist));
				Date now = new Date();
				String dirDate = DateUtil.systemDate.format(now);
				File dir = new File(tempfolder + dirDate);
				if(!dir.exists()) {
					dir.mkdirs();
				}
				String listStr = JSONObject.toJSONString(dataSycDto);
                String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(listStr.getBytes(), Constants.APPROVAL_KEY));
                
                String filepath = FileUtil.writeTxtFile(content,"problemPerson",tempfolder);
                if(StringUtil.isNotEmpty(filepath)){
                	File file = new File(filepath);
        			if(file != null) {
        				ServletOutputStream out = response.getOutputStream();
        				String fileName = new String(file.getName().substring(file.getName().indexOf("_")+1).getBytes("UTF-8"),"iso-8859-1");
        				response.addHeader("Content-Disposition","attachment;filename=" + fileName);
        				InputStream is = new FileInputStream(file);
        				int read = 0;
        				byte[] buffer = new byte[8192];
        				while ((read = is.read(buffer)) != -1) {
        					out.write(buffer, 0, read);
        				}
        				is.close();
        				out.flush();
        				out.close();
        			}
                }else{
                }
			}else{
			}
		}catch (BadPaddingException badPaddingException){
			logger.error(badPaddingException.getMessage(), badPaddingException);
			throw new ArsException("导入失败，非该区域数据\n！");
		}catch(Exception e){
			logger.error(e.getMessage(), e);
			throw e;
		}
	}


	/***
	 * 进入问题人员处理页面
	 * @return 页面路径
	 */
	@RequestMapping("/problemDetail")
	public ModelAndView problemDetail(String idnum) {
		ModelAndView view = new ModelAndView("problemperson/problemDetail");
		String result = bjProblemDetailUtil.checkPersonInfo(idnum);
		if (StringUtil.isNotEmpty(result)) {
			result = result.replaceAll("RESOURCE_TYPE","资源类型");
			ProblemResult censorResult = JSONObject.parseObject(result, ProblemResult.class);
			if (censorResult.getResults() != null && !censorResult.getResults().isEmpty()) {
				view.addObject("problemDetails", JSON.toJSONString(censorResult.getResults()));
			}
		}
		return view;
	}


	public static void main(String[] args) {

		String result = "{\n" +
				"  \"msg\": \"ok\",\n" +
				"  \"status\": 0,\n" +
				"  \"results\": [\n" +
				"    {\n" +
				"      \"RESOURCE_TYPE\": \"监管看守所\",\n" +
				"      \"入所日期\": \"2021-03-09 23:42:53\",\n" +
				"      \"简要案情\": \"2021年3月8日20时许,杜志良报警称在本市丰台区太平桥华源一里8号院门口,手机丢失.后经丰台价格认证中心工作人员口头答复,被盗手机价格为2500元\",\n" +
				"      \"入所原因\": \"刑事拘留\",\n" +
				"      \"单位\": \"丰台区看守所\",\n" +
				"      \"涉嫌罪名\": \"盗窃案\"\n" +
				"    },\n" +
				"    {\n" +
				"      \"立案单位\": \"鞍山市铁西区人民法院\",\n" +
				"      \"纳入部级重点人员库时间\": \"2020-10-15 11:43:10\",\n" +
				"      \"最近立案时间\": \"2018-09-08 11:55:43\",\n" +
				"      \"RESOURCE_TYPE\": \"部下发重大犯罪前科\",\n" +
				"      \"重点人员细类\": \"抢劫案;故意伤害罪\"\n" +
				"    }\n" +
				"  ]\n" +
				"}";

		if (StringUtil.isNotEmpty(result)) {
			ProblemResult problemResult = JSONObject.parseObject(result, ProblemResult.class);

			for (Object resultResult : problemResult.getResults()) {
				System.out.println(resultResult);
			}

		}
	}
}
