package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.sb.SponsorlicenseDto;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.sb.Legalchangeworkexperience;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.service.sb.*;
import com.bcxin.ars.service.sys.ApprovalLogService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.util.ConfigSignUtils;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.approval.BusinessType;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author linqinglin
 * @date 2020/07/17 0017 14:07
 */
@Controller
@RequestMapping("print")
public class PrintController {

    @Autowired
    private ApprovalService approvalService;

    @Autowired
    private ApprovalLogService approvalLogService;

    @Autowired
    private TraincompanyapplyService traincompanyapplyService;

    @Autowired
    private SponsorlicenseService sponsorlicenseService;

    @Autowired
    private LegalchangeService legalchangeService;

    @Autowired
    private LegalchangeworkexperienceService workexperienceService;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ConfigSignUtils configSignUtils;

    @Autowired
    private BusinessService businessService;

    @RequestMapping("choicePrint/{approvalId}")
    public ModelAndView printPage(@PathVariable("approvalId") Long approvalId){
        ModelAndView view = new ModelAndView("print/choicePrint");

        Approval approval = approvalService.findById(approvalId);
        view.addObject("approval",approval);
        return view;
    }

    @RequestMapping("detail")
    public ModelAndView detail(Long approvalId){
        Approval approval =approvalService.findById(approvalId);

        BusinessCommon detail = businessService.findByBusinessTypeAndId(approval.getBusinesstype(), approval.getBusinessid());

        Long businessId = approval.getBusinessid();
        ModelAndView view = new ModelAndView("print/detail"+approval.getBusinesstype());
        if(BusinessType.BAFWGS.equals(approval.getBusinesstype())){
            SponsorlicenseDto sponsorlicense = sponsorlicenseService.getDetail(approval.getBusinessid());
            view.addObject("record",sponsorlicense);

        }else if(BusinessType.PXDW.equals(approval.getBusinesstype())){
            //TODO
            view.addObject("record",detail);

        }else if(BusinessType.FRBG.equals(approval.getBusinesstype())){
            view.addObject("record",detail);
            List<Legalchangeworkexperience> workexperiences = workexperienceService.findByLegalchangeId(businessId);
            view.addObject("workexperiences",workexperiences);
        }

        return view;
    }


    @RequestMapping("handle")
    public ModelAndView handle(Long approvalId,String handleType){
        Approval approval =approvalService.findById(approvalId);
        ModelAndView view = new ModelAndView("print/handle"+configUtils.getCurrentNative());

        String type="1";
        if(BusinessType.FRBG.equals(approval.getBusinesstype())){
            type="2";
        }
        String configSign=configSignUtils.getConfigSign(type,configUtils.getCurrentProvince());
        Map mapTypes = JSON.parseObject(configSign);
        view.addObject("tableMessage", JSONObject.fromObject(configSign));

        switch (handleType){
            case "1":
                Map map = approvalService.findByApprovalId(approval.getId());
                Map messageMap=new HashMap();
                Long businessId = approval.getBusinessid();
                if(BusinessType.BAFWGS.equals(approval.getBusinesstype())){
                    messageMap= sponsorlicenseService.searchForPrintf(businessId);
                }else if(BusinessType.PXDW.equals(approval.getBusinesstype())){
                    messageMap=   traincompanyapplyService.searchForPrintf(businessId);
                }else if(BusinessType.FRBG.equals(approval.getBusinesstype())){
                    messageMap=legalchangeService.searchForPrintf(businessId);
                }
                view.addObject("companyDetail", map);
                view.addObject("messageMap",messageMap);
                break;
            case "2":
                mapTypes.put("approvalId",approval.getId());
                Map approvalLogMap= approvalLogService.findPrintfMessageByApprovalId(mapTypes);
                view.addObject("approvalMessage", approvalLogMap);
                break;
            case "3":
                List<ApprovalLog> logList = approvalLogService.findByApprovalId(approval.getId().toString());
                view.addObject("logList", logList);
                break;
            default:
                break;
        }
        return view;
    }


    @RequestMapping("processHistory")
    public ModelAndView processHistory(Long approvalId){
        ModelAndView view = new ModelAndView("print/processHistory");
        if (approvalId == null) {
            return null;
        }
        List<ApprovalLog> logList = approvalLogService.findByApprovalId(approvalId.toString());
        view.addObject("logList", logList);
        return view;
    }

}
