package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.PersonBlackListDto;
import com.bcxin.ars.dto.page.PersonBlackListPageSearchDto;
import com.bcxin.ars.model.PersonBlackList;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.PersonBlackListService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 保安行业黑名单 控制层
 * @author linqinglin
 * @date 2019/05/13 0013 11:12
 */
@Controller
@RequestMapping("personBlackList")
public class PersonBlackListController {

    private Logger logger = LoggerFactory.getLogger(PersonBlackListController.class);

    @Autowired
    private PersonBlackListService personBlackListService;

    @Autowired
    private ArsUtil arsUtil;

    @RequestMapping("list/index")
    @RequiresPermissions("personBlackListManager:query")
    public ModelAndView listIndex(PersonBlackListPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("personBlackList/list");
        view.addObject("record",searchDto);
        return view;
    }

    @RequestMapping("searchForPage")
    @RequiresPermissions("personBlackListManager:query")
    @ResponseBody
    public AjaxPageResponse searchForPage(PersonBlackListPageSearchDto dto, AjaxPageResponse<PersonBlackListDto> page){
        personBlackListService.searchForPage(dto,page);
        return page;
    }

    @RequestMapping("{pageName}/index")
    @RequiresPermissions(logical = Logical.OR,value ={"personBlackListManager:query","personBlackListManager:edit","personBlackListManager:add"})
    public ModelAndView editIndex(@PathVariable String pageName, @RequestParam(required = false) Long id){
        User currentUser = arsUtil.getCurrentUser();
        PersonBlackList detail= null;
        ModelAndView view = new ModelAndView("personBlackList/"+pageName);
        if(id != null) {
            detail = personBlackListService.findById(id);
        }else{
            detail = new PersonBlackList();
            detail.setRegisterDate(DateUtil.getCurrentDate());
            detail.setOrgId(currentUser.getPolice().getId());
            detail.setOrgName(currentUser.getPolice().getOrgname());
            detail.setAreaCode(currentUser.getPolice().getAreacode());
            detail.setRegistrant(currentUser.getRealname());
        }
        view.addObject("content", detail);
        return view;
    }

    @RequestMapping("update")
    @ResponseBody
    public AjaxResult update(PersonBlackList detail) {
        AjaxResult result = new AjaxResult();
        try {
            personBlackListService.update(detail);
            result.setSuccessful(true);
            result.setMsg("操作成功！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    @RequestMapping("delete")
    @ResponseBody
    public AjaxResult delete(PersonBlackList detail) {
        AjaxResult result = new AjaxResult();
        try {
            personBlackListService.delete(detail);
            result.setSuccessful(true);
            result.setMsg("操作成功！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
