package com.bcxin.ars.rest;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.GuardStatus;
import com.bcxin.ars.util.Constants;

@Controller
@RequestMapping("guardStatus")
public class GuardStatusController {
	
	/**
	 * 获取在岗状态列表
	 * @param request
	 * @return
	 */
	@RequestMapping("findAll")
	public @ResponseBody AjaxResult findAll(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.GUARDSTATUS_LIST);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 获取在岗状态列表
	 * @param request
	 * @return
	 */
	@RequestMapping("findAllForMap")
	public @ResponseBody AjaxResult findAllForMap(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.GUARDSTATUS_MAP);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 根据ID获取在岗状态
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id, HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.GUARDSTATUS_MAP);
		if(data != null) {
			Map<Long, GuardStatus> guardStatusMap = (Map<Long, GuardStatus>)data;
			GuardStatus guardStatus = guardStatusMap.get(id);
			if(guardStatus != null) {
				result.setSuccessful(true);
				result.setData(guardStatus);
			} else {
				result.setSuccessful(false);
				result.setMsg("未找到常量数据。ID:" + id);
			}
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
}
