package com.bcxin.ars.rest;

import com.bcxin.ars.dao.datasync.FileRecordDetailDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.FilerecordPageSearchDto;
import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.service.FilerecordService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 数据同步日志控制器
 *
 * @author linqinglin
 * @Date 2020-01-22 09:29:06
 */
@Controller
@RequestMapping("filerecord")
public class FilerecordController {

	Logger logger = LoggerFactory.getLogger(FilerecordController.class);

	@Autowired
	FilerecordService filerecordService;

	@Autowired
	FileRecordDetailDao  fileRecordDetailDao;

	/**
	 * 管理列表页面
	 * @return
	 */
	@RequestMapping("list/index")
	public ModelAndView listIndex(FilerecordPageSearchDto searchDto){
		ModelAndView view = new ModelAndView("/filerecord/list");
		view.addObject("record",searchDto);
		return view;
	}

	/**
	 * 查看页面
	 * @param id
	 * @return
	 */
	@RequestMapping("detail/index")
	public ModelAndView detailIndex(Long id){
		ModelAndView view = new ModelAndView("/filerecord/detail");
		Filerecord filerecord = filerecordService.findById(id);
		filerecord.setErrorDetailList(fileRecordDetailDao.findByRecordId(filerecord.getId()));
		view.addObject("record",filerecord);

		return view;
	}


	/**
	 * 删除任务
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody
	AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			filerecordService.delete(id);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(FilerecordPageSearchDto dto, AjaxPageResponse<Filerecord> page){
		filerecordService.searchForPage(dto,page);
		return page;
	}
}

