package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;

import com.bcxin.ars.dto.page.EnrolmentLeaveBeijingSearchDto;
import com.bcxin.ars.model.EnrolmentLeaveBeijing;
import com.bcxin.ars.service.EnrolmentLeaveBeijingService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import org.apache.shiro.authz.annotation.RequiresPermissions;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;


/**
 * 保安员离京登记Controller
 *
 * @author zyt
 * @date 2021-02-01
 */
@Controller
@RequestMapping("/enrolmentLeaveBeijing")
public class EnrolmentLeaveBeijingController{
    Logger logger = LoggerFactory.getLogger(EnrolmentLeaveBeijingController.class);

    @Autowired
    private EnrolmentLeaveBeijingService enrolmentLeaveBeijingService;


    /**
     * 管理列表页面
     * @return
     */
    @RequestMapping("list/index")
    @RequiresPermissions("enrolmentLeaveBeijing:view")
    public ModelAndView listIndex(EnrolmentLeaveBeijingSearchDto searchDto){
        ModelAndView view = new ModelAndView("enrolmentLeaveBeijing/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(EnrolmentLeaveBeijingSearchDto dto, AjaxPageResponse<EnrolmentLeaveBeijing> page){
        enrolmentLeaveBeijingService.searchForPage(dto,page);
        return page;
    }

    /**
     * 查看页面
     * @param enrolmentLeaveBeijing
     * @return
     */
    @RequestMapping("detail/index")
    public ModelAndView detailIndex(EnrolmentLeaveBeijing enrolmentLeaveBeijing){
        ModelAndView view = new ModelAndView("enrolmentLeaveBeijing/detail");

        if(enrolmentLeaveBeijing.getId() != null){
            view.addObject("record",enrolmentLeaveBeijingService.findById(enrolmentLeaveBeijing.getId()));
        }else {
            view.addObject("record", enrolmentLeaveBeijing);
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param enrolmentLeaveBeijing
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(EnrolmentLeaveBeijing enrolmentLeaveBeijing){
        ModelAndView view = new ModelAndView("enrolmentLeaveBeijing/edit");

        if(enrolmentLeaveBeijing.getId() != null){
            view.addObject("record",enrolmentLeaveBeijingService.findById(enrolmentLeaveBeijing.getId()));
        }else {
            view.addObject("record", enrolmentLeaveBeijing);
        }

        return view;
    }

    /**
     * 保存
     * @param enrolmentLeaveBeijing
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(EnrolmentLeaveBeijing enrolmentLeaveBeijing){
        AjaxResult result = new AjaxResult();
        try {
            enrolmentLeaveBeijingService.save(enrolmentLeaveBeijing);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

}
