package com.bcxin.ars.rest;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Edu;
import com.bcxin.ars.util.Constants;

@Controller
@RequestMapping("edu")
public class EduController {
	
	/**
	 * 获取学历列表
	 * @param request
	 * @return
	 */
	@RequestMapping("findAll")
	public @ResponseBody AjaxResult findAll(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.EDU_LIST);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 获取学历列表
	 * @param request
	 * @return
	 */
	@RequestMapping("findAllForMap")
	public @ResponseBody AjaxResult findAllForMap(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.EDU_MAP);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 根据ID获取学历
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id, HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.EDU_MAP);
		if(data != null) {
			Map<Long, Edu> eduMap = (Map<Long, Edu>)data;
			Edu edu = eduMap.get(id);
			if(edu != null) {
				result.setSuccessful(true);
				result.setData(edu);
			} else {
				result.setSuccessful(false);
				result.setMsg("未找到常量数据。ID:" + id);
			}
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
}
