package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.CyServerhtSearchDto;
import com.bcxin.ars.model.CyServerht;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.CyServerhtService;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * 服务合同
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月1日 下午2:29:20
 * @注意事项 </b>
 * <b>
 */

@Controller
@RequestMapping("cyServerht")
public class CyserverhtController {
	
	private static final Logger logger = LoggerFactory.getLogger(CyserverhtController.class);
	
	@Autowired
	private CyServerhtService cyServerhtService;

	@Autowired
	private SecurityPersonService securityPersonService;

	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getcyServerhtList")
	public @ResponseBody AjaxResult update(CyServerhtSearchDto cyServerhtSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if (user.getPlatform() == 2) {
					cyServerhtSearchDto.setUserid(user.getId());
				}
			}
			CyServerhtSearchDto data = cyServerhtService.search(cyServerhtSearchDto);
			result.setSuccessful(true);
			result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新服务合同信息
	 * @param cyServerht 服务合同信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(CyServerht cyServerht) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			cyServerhtService.saveOrUpdate(cyServerht);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 删除服务合同信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			CyServerht cyServerht = cyServerhtService.findById(id);

			if(cyServerht != null) {
				cyServerhtService.delete(cyServerht);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取服务合同信息
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			CyServerht cyServerht = cyServerhtService.findById(id);
			result.setSuccessful(true);
			result.setData(cyServerht);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 解除合同
	 * <b>Function </b> 
	 * 
	 * @param htId
	 * @return
	 * @author LinQingLin 
	 * @date 2017年5月19日 下午7:51:23
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("relieveHt")
	public @ResponseBody AjaxResult relieveHt(Long htId) throws Exception {
		try {
			return cyServerhtService.relieveHt(htId);
		} catch (Exception e) {
			throw e;
		}
	}
}
