package com.bcxin.ars.rest;

import com.bcxin.ars.dto.page.ComStateChangeLogPageSearchDto;
import com.bcxin.ars.model.ComStateChangeLog;
import com.bcxin.ars.service.ComStateChangeLogService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;


/**
 * 自招单位状态变更日志Controller
 * 
 * @author lin
 * @date 2020-11-04
 */
@Controller
@RequestMapping("/comStateChangeLog")
public class ComStateChangeLogController{
    Logger logger = LoggerFactory.getLogger(ComStateChangeLogController.class);

    @Autowired
    private ComStateChangeLogService comStateChangeLogService;


    /**
      * 管理列表页面
      * @return
      */
    @RequestMapping("list/index")
    @RequiresPermissions("comStateChangeLog:view")
    public ModelAndView listIndex(ComStateChangeLogPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("comStateChangeLog/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    @RequiresPermissions("comStateChangeLog:view")
    public AjaxPageResponse searchForPage(ComStateChangeLogPageSearchDto dto, AjaxPageResponse<ComStateChangeLog> page){
        comStateChangeLogService.searchForPage(dto,page);
        return page;
    }

    /**
     * 查看页面
     * @param comStateChangeLog
     * @return
     */
    @RequestMapping("detail/index")
    @RequiresPermissions("comStateChangeLog:view")
    public ModelAndView detailIndex(ComStateChangeLog comStateChangeLog){
        ModelAndView view = new ModelAndView("comStateChangeLog/detail");

        if(comStateChangeLog.getId() != null){
            view.addObject("record",comStateChangeLogService.findById(comStateChangeLog.getId()));
        }else {
            view.addObject("record", comStateChangeLog);
        }

        return view;
    }


}
