package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.task.TaskCatalog;
import com.bcxin.ars.model.task.TaskLevel;
import com.bcxin.ars.model.task.TaskStatus;
import com.bcxin.ars.model.task.TaskType;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.ftp.FtpUtils;
import com.beust.jcommander.internal.Maps;
import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;


@Controller
@RequestMapping("/")
@Slf4j
public class BaseController {
	
	private Logger logger = LoggerFactory.getLogger(BaseController.class);
	
	@Value("${base-folder}")
	private String baseFolder;
	
	@Value("${upload-folder}")
	private String uploadFolder;

	@Value("${temp-folder}")
	private String tempFolder;

	@Value("${pdf-folder}")
	private String pdfFolder;
    @Autowired
    private ConfigUtils configUtils;
	//在线预览请求url
	@Value("${PREVIEW_FILE_URL}")
	private String previewFileUrl;

    //北京ftp临时目录
    @Value("${ftpServerTemp}")
    private String ftpServerTemp;

	@Value("${personImg-folder}")
	private String personImg;


	@Autowired
	private ArsRestUtil arsRestUtil;
	
	@Autowired
	private SecurityPersonService personService;
	/**
	 * 上传文件
	 * @param file
	 * @return
	 */
	@RequestMapping("uploadFile")
	public @ResponseBody AjaxResult uploadFile(MultipartFile file) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Date now = new Date();

			if(file == null ){
				return result;
			}
            String originalFilename = file.getOriginalFilename();
            String fileRealName = originalFilename.substring(0,originalFilename.lastIndexOf(".")); //文件名
            String materialFileType = originalFilename.substring(originalFilename.lastIndexOf(".")+1); //文件类型

			//文件类型
			/***  上传的文件类型可能小写、可能大写、可能大小混合 by llc 2018-08-21 ***/
			String fileType = "ZIP,RAR,PDF,TXT,XML,DOC,GIF,PNG,BMP,JPEG,JPG,DOCX,XLS,XLSX,PPT,PPTX";
//			判断是否为允许上传的文件类型
			if ( !Arrays.<String> asList(fileType.split(",")).contains(materialFileType.toUpperCase()))
			{   result.setSuccessful(false);
				result.setMsg("文件格式不对，重新上传！！");
				return result;
			}
			String fileName = now.getTime() +"."+ materialFileType;
			String dirDate = DateUtil.systemDate.format(now);
			File dir = new File(uploadFolder + dirDate);
			if(!dir.exists()) {
				dir.mkdirs();
			}
			String key = "upload/" + dirDate + "/" + fileName;
			String url = "getResource.do?path=" + key;
			String targetPath = uploadFolder + dirDate + "/" + fileName;
			File targetFile = new File(targetPath);
			logger.info("执行本地文件上传..." + targetFile);
			file.transferTo(targetFile);
			Map<String,String> map = new HashMap<String, String>();
			map.put("fileRealName", fileRealName);

			map.put("key", key);
			map.put("url", url);
			String imgValue = url + "||" + file.getOriginalFilename() + "&&" ; // 图片值
			logger.info("本地文件上传成功!");
			/***********************edit 2018-04-30 subh 增加上传文件是否为rar5 start*****************************************/
			//判断rar格式是否正确
			if("rar".equals(materialFileType)) {
				Archive archive = new Archive(new File(baseFolder + key));
				//junrar只支持rar5以下的解压，不支持rar5，所以这边判断是否是rar5，如果是，提示重新上传 TODO
				List<FileHeader> headers = archive.getFileHeaders();
				//是rar5返回的话，headers为空
				if (headers == null || headers.size() == 0) {
					result.setSuccessful(false);
					result.setMsg(Constants.RAR_ERROR_MSG);
					return result;
				}
			}
			/***********************edit 2018-04-30 subh 增加上传文件是否为rar5 end*****************************************/
			result.setSuccessful(true);
			result.setData(map);
			result.setObj(imgValue);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	/**
	 * 上传文件
	 * @param file
	 * @return
	 */
	@RequestMapping("uploadFileForString")
	public @ResponseBody String uploadFileForString(MultipartFile file) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Date now = new Date();

			if(file == null ){
				return JSON.toJSONString(result);
			}
            String originalFilename = file.getOriginalFilename();
            //文件名
            String fileRealName = originalFilename.substring(0,originalFilename.lastIndexOf("."));
            //文件类型
            String materialFileType = originalFilename.substring(originalFilename.lastIndexOf(".")+1);
			//文件类型
			/***  上传的文件类型可能小写、可能大写、可能大小混合 by llc 2018-08-21 ***/
			String fileType = "ZIP,RAR,PDF,TXT,XML,DOC,GIF,PNG,BMP,JPEG,JPG,DOCX,XLS,XLSX,PPT,PPTX";
//			判断是否为允许上传的文件类型
			if ( !Arrays.<String> asList(fileType.split(",")).contains(materialFileType.toUpperCase()))
			{   result.setSuccessful(false);
				result.setMsg("文件格式不对，重新上传！！");
				return JSON.toJSONString(result);
			}
			String fileName = now.getTime() +"."+ materialFileType;
			String dirDate = DateUtil.systemDate.format(now);
			File dir = new File(uploadFolder + dirDate);
			if(!dir.exists()) {
				dir.mkdirs();
			}
			String key = "upload/" + dirDate + "/" + fileName;
			String url = "getResource.do?path=" + key;
			String targetPath = uploadFolder + dirDate + "/" + fileName;
			File targetFile = new File(targetPath);
			logger.info("执行本地文件上传..." + targetFile);
			file.transferTo(targetFile);
			Map<String,String> map = new HashMap<String, String>();
			map.put("fileRealName", fileRealName);

			map.put("key", key);
			map.put("url", url);
			String imgValue = url + "||" + file.getOriginalFilename() + "&&" ; // 图片值
			logger.info("本地文件上传成功!");
			/***********************edit 2018-04-30 subh 增加上传文件是否为rar5 start*****************************************/
			//判断rar格式是否正确
			if("rar".equals(materialFileType)) {
				Archive archive = new Archive(new File(baseFolder + key));
				//junrar只支持rar5以下的解压，不支持rar5，所以这边判断是否是rar5，如果是，提示重新上传 TODO
				List<FileHeader> headers = archive.getFileHeaders();
				//是rar5返回的话，headers为空
				if (headers == null || headers.size() == 0) {
					result.setSuccessful(false);
					result.setMsg(Constants.RAR_ERROR_MSG);
					return "";
				}
			}
			/***********************edit 2018-04-30 subh 增加上传文件是否为rar5 end*****************************************/
			result.setSuccessful(true);
			result.setData(map);
			result.setObj(imgValue);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return JSON.toJSONString(result);
	}


	/****
	 * 判断字符串是否为日期格式
	 * @param str
	 * @return
	 */
	public static boolean isValidDate(String str) {
		boolean convertSuccess=true;
		// 指定日期格式为四位年/两位月份/两位日期，注意yyyy/MM/dd区分大小写；
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		try {
			// 设置lenient为false. 否则SimpleDateFormat会比较宽松地验证日期，比如2007/02/29会被接受，并转换成2007/03/01
			format.setLenient(false);
			format.parse(str);
		} catch (ParseException e) {
			// e.printStackTrace();
			// 如果throw java.text.ParseException或者NullPointerException，就说明格式不对
			convertSuccess=false;
		}
		return convertSuccess;

	}

	public static void main(String[] args) throws Exception{

		/*String path ="upload/2018-01-21/121.jpg";
		//判断是否为三段式，不是三段式则有问题路径
		String[] paths =  path.split("/");
		if(paths.length!=3){
			throw new Exception("系统错误！！！");
		}else{
			//判断第二段是否为日期
			if(!isValidDate(paths[1])) {
				throw new Exception("系统错误！！！");
			}
			String fileType = paths[2];
			String[] temp =fileType.split("\\.");
			if(temp.length!=2){
				throw new Exception("系统错误！！！");
			}
			//文件名是否为时间戳
			String fileName = fileType.split("\\.")[0]; //文件类型
			if(!timeStampDate(fileName)){
				throw new Exception("系统错误！！！");
			}
			//文件类型判断
			if(!StringFilter(fileType)){
				throw new Exception("系统错误！！！");
			}
		}
		System.out.println("d1");*/
		String materialFileType = "doc";
		//允许上传的文件类型
		String fileType = "zip,rar,pdf,txt,xml,doc,gif,png,bmp,jpeg,jpg,docx,xls,xlsx,ppt,pptx";
		//判断是否为允许上传的文件类型
		if ( !Arrays.<String> asList(fileType.split(",")).contains(materialFileType))
		{
			throw new Exception("系统错误！！！");
		}

	}
	/***
	 * 过滤非法字符
	 * @param str
	 * @return
	 * @throws PatternSyntaxException
	 */
	public   static   boolean StringFilter(String   str)   throws PatternSyntaxException {
		boolean resulst = true;
		String regEx = "[ `~!@#$%^&*()+=|{}':;',\\[\\]<>?~！@#￥%……&*（）—+|{}【】‘；：”“’。，、？]|\n|\r|\t";
		//不允许..
		if(str.indexOf("..")>0){
			resulst =false;
		}
		//非法字符
		Pattern p = Pattern.compile(regEx);
		Matcher m = p.matcher(str);

		if(m.find()){
			resulst = false;
		}
		return  resulst;
	}
	/***
	 * 时间戳转日期类型
	 * @param seconds
	 * @return
	 */
	public static boolean timeStampDate(String seconds) {
		boolean convertSuccess=true;
		try {
			if(seconds == null || seconds.isEmpty() || seconds.equals("null")){
				return false;
			}
			String format="yyyy-MM-dd";
			SimpleDateFormat sdf = new SimpleDateFormat(format);
			sdf.format(new Date(Long.valueOf(seconds+"000")));
		} catch (Exception e) {
			// e.printStackTrace();
			// 如果throw java.text.ParseException或者NullPointerException，就说明格式不对
			convertSuccess=false;
		}
		return convertSuccess;
	}
	/**
	 * 下载文件用于FTP
	 * @param path
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "getResourceFTP")
	public void getResourceFTP(String path, HttpServletResponse response) throws Exception {
        //判断是否启动ftpserver
        Config config = configUtils.getConfigByKey(Constants.FTPSERVER);
        File file = null;
        InputStream is = null;
        ServletOutputStream out = null;
        String suffix = path.substring(path.lastIndexOf(".") + 1);
        //ftp只能取图片，zip或rar从硬盘取
        String fileTypes = "ZIP,RAR";
        if(config != null && Constants.FTPSERVER_YES.equals(config.getValue()) && path.startsWith("upload") &&
                !Arrays.<String> asList(fileTypes.split(",")).contains(suffix.toUpperCase())
        ) {
            String[] paths =  path.split("/");
            if(paths.length!=3){
                throw new Exception("系统错误！！！");
            }
            //文件路径
            String filePath =  paths[0] + "/" + paths[1];
            //文件名称
            String fileName = paths[2];
            try {
                file = FtpUtils.downloadFile(Constants.BJ_FTPHOST, Constants.BJ_FTPUSERNAME, Constants.BJ_FTPPASSWORD, Constants.BJ_PORT, filePath,ftpServerTemp+DateUtil.systemDate.format(new Date())+"/", fileName);
                is = new FileInputStream(file);
                out = response.getOutputStream();
                fileName = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
            }catch (Exception e ){
                logger.error(e.getMessage(),e);
            }finally {
                if(is!=null){
                    is.close();
                }
                if(out!=null){
                    out.flush();
                    out.close();
                }
            }
        }else{
            if(path.startsWith("upload")) {
                file = new File(baseFolder + path);
            } else if(path.startsWith("temp")) {
                file = new File(baseFolder + path);
            }  else if(path.startsWith("pdf")) {
                file = new File(baseFolder + path);
            }else if(path.startsWith("sysAttachment")) {
                file = new File(baseFolder + path);
            }else if(path.startsWith("approveAttachment")) {
                file = new File(baseFolder + path);
            }else if(path.startsWith("personImg")) {
                file = new File(baseFolder + path);
            }else{
                throw new Exception("系统错误！！！");
            }
            logger.info("文件路径： " + file.getPath());
            //判断是否为三段式，不是三段式则有问题路径
            String[] paths =  path.split("/");
            if(paths.length!=3){
                throw new Exception("系统错误！！！");
            }else{
                //判断第二段是否为日期
                if(!isValidDate(paths[1])) {
                    throw new Exception("系统错误！！！");
                }
                String fileType = paths[2];
                String[] temp =fileType.split("\\.");
                if(temp.length!=2){
                    throw new Exception("系统错误！！！");
                }
                //文件名是否为时间戳
                /*String fileName = fileType.split("\\.")[0]; //文件类型
                /*if(!timeStampDate(fileName)){
                    throw new Exception("系统错误！！！");
                }*/
                //文件类型判断
                if(!StringFilter(fileType)){
                    throw new Exception("系统错误！！！");
                }
            }
            if(file != null) {
                try {
                    out = response.getOutputStream();
                    String fileName = new String(file.getName().getBytes("UTF-8"),"iso-8859-1");
                    response.addHeader("Content-Disposition","attachment;filename=" + fileName);
                    is = new FileInputStream(file);
                    int read = 0;
                    byte[] buffer = new byte[8192];
                    while ((read = is.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                }catch (Exception e ){
                    logger.error(e.getMessage(),e);
                }finally {
                    if(is!=null){
                        is.close();
                    }
                    if(out!=null){
                        out.flush();
                        out.close();
                    }
                }
            }
        }
	}
    /**
     * 下载文件用于FTP
     * @param path
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "getResourceFTPTemp")
    public void getResourceFTPTemp(String path, HttpServletResponse response) throws Exception {
        //判断是否启动ftpserver
        File file = null;
        InputStream is = null;
        ServletOutputStream out = null;
        String suffix = path.substring(path.lastIndexOf(".") + 1);
        //ftp只能取图片，zip或rar从硬盘取
        if(path.startsWith("upload")) {
            file = new File(baseFolder + path);
        } else if(path.startsWith("temp")) {
            file = new File(baseFolder + path);
        }  else if(path.startsWith("pdf")) {
            file = new File(baseFolder + path);
        }else if(path.startsWith("sysAttachment")) {
            file = new File(baseFolder + path);
        }else if(path.startsWith("approveAttachment")) {
            file = new File(baseFolder + path);
        }else if(path.startsWith("personImg")) {
            file = new File(baseFolder + path);
        }else{
            throw new Exception("系统错误！！！");
        }
        logger.info("文件路径： " + file.getPath());
        //判断是否为三段式，不是三段式则有问题路径
        String[] paths =  path.split("/");
        if(paths.length!=3){
            throw new Exception("系统错误！！！");
        }else{
            //判断第二段是否为日期
            if(!isValidDate(paths[1])) {
                throw new Exception("系统错误！！！");
            }
            String fileType = paths[2];
            String[] temp =fileType.split("\\.");
            if(temp.length!=2){
                throw new Exception("系统错误！！！");
            }
            //文件名是否为时间戳
            /*String fileName = fileType.split("\\.")[0]; //文件类型
            /*if(!timeStampDate(fileName)){
                throw new Exception("系统错误！！！");
            }*/
            //文件类型判断
            if(!StringFilter(fileType)){
                throw new Exception("系统错误！！！");
            }
        }
        if(file != null) {
            try {
                out = response.getOutputStream();
                String fileName = new String(file.getName().getBytes("UTF-8"),"iso-8859-1");
                response.addHeader("Content-Disposition","attachment;filename=" + fileName);
                is = new FileInputStream(file);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
            }catch (Exception e ){
                logger.error(e.getMessage(),e);
            }finally {
                if(is!=null){
                    is.close();
                }
                if(out!=null){
                    out.flush();
                    out.close();
                }
            }
        }
    }
    /**
     * 下载文件
     * @param path
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "getResource")
    public void getResource(String path, HttpServletResponse response) throws Exception {
        //判断是否启动ftpserver
        Config config = configUtils.getConfigByKey(Constants.FTPSERVER);
        File file = null;
        InputStream is = null;
        ServletOutputStream out = null;
        String suffix = path.substring(path.lastIndexOf(".") + 1);
        //ftp只能取图片，zip或rar从硬盘取
        String fileTypes = "ZIP,RAR";
        if(config != null && Constants.FTPSERVER_YES.equals(config.getValue()) && path.startsWith("upload") &&
                !Arrays.<String> asList(fileTypes.split(",")).contains(suffix.toUpperCase())
        ) {
            String[] paths =  path.split("/");
            if(paths.length!=3){
                throw new Exception("系统错误！！！");
            }
            //文件路径
            String filePath =  paths[0] + "/" + paths[1];
            //文件名称
            String fileName = paths[2];
            try {
                file = FtpUtils.downloadFile(Constants.BJ_FTPHOST, Constants.BJ_FTPUSERNAME, Constants.BJ_FTPPASSWORD, Constants.BJ_PORT, filePath,ftpServerTemp+DateUtil.systemDate.format(new Date())+"/", fileName);
                is = new FileInputStream(file);
                out = response.getOutputStream();
                fileName = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                //用完删除
          //      file.delete();
            }catch (Exception e ){
                e.printStackTrace();
                logger.error(e.getMessage(),e);
            }finally {
                if(is!=null){
                    is.close();
                }
                if(out!=null){
                    out.flush();
                    out.close();
                }
            }
        }else{
            if(path.startsWith("upload")) {
                file = new File(baseFolder + path);
            } else if(path.startsWith("temp")) {
                file = new File(baseFolder + path);
            }  else if(path.startsWith("pdf")) {
                file = new File(baseFolder + path);
            }else if(path.startsWith("sysAttachment")) {
                file = new File(baseFolder + path);
            }else if(path.startsWith("approveAttachment")) {
                file = new File(baseFolder + path);
            }else if(path.startsWith("personImg")) {
                file = new File(baseFolder + path);
            }else{
                throw new Exception("系统错误！！！");
            }
            logger.info("文件路径： " + file.getPath());
            //判断是否为三段式，不是三段式则有问题路径
            String[] paths =  path.split("/");
            if(paths.length!=3){
                throw new Exception("系统错误！！！");
            }else{
                //判断第二段是否为日期
                if(!isValidDate(paths[1])) {
                    throw new Exception("系统错误！！！");
                }
                String fileType = paths[2];
                String[] temp =fileType.split("\\.");
                if(temp.length!=2){
                    throw new Exception("系统错误！！！");
                }
                //文件名是否为时间戳
                /*String fileName = fileType.split("\\.")[0]; //文件类型
                /*if(!timeStampDate(fileName)){
                    throw new Exception("系统错误！！！");
                }*/
                //文件类型判断
                if(!StringFilter(fileType)){
                    throw new Exception("系统错误！！！");
                }
            }
            if(file != null) {
                try {
                    out = response.getOutputStream();
                    String fileName = new String(file.getName().getBytes("UTF-8"),"iso-8859-1");
                    response.addHeader("Content-Disposition","attachment;filename=" + fileName);
                    is = new FileInputStream(file);
                    int read = 0;
                    byte[] buffer = new byte[8192];
                    while ((read = is.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                }catch (Exception e ){
                    logger.error(e.getMessage(),e);
                }finally {
                    if(is!=null){
                        is.close();
                    }
                    if(out!=null){
                        out.flush();
                        out.close();
                    }
                }
            }
        }
    }

    /**
	 * 获取民族列表
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("getNation")
	public @ResponseBody AjaxResult getNation(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<Nation> nationList = (List<Nation>) request.getSession().getServletContext().getAttribute(Constants.NATION_LIST);
			result.setSuccessful(true);
			result.setData(nationList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 获取指定代号下的省市县
	 * @param code 默认0表示获取所有省数据
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("getNative/{code}")
	public @ResponseBody AjaxResult getNative(@PathVariable("code")Long code, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Map<Long, List<Native>> nativeMap = (Map<Long, List<Native>>) request.getSession().getServletContext().getAttribute(Constants.NATIVE_MAP);
			List<Native> data = nativeMap.get(code);
			result.setSuccessful(true);
			result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据身份证号获取籍贯
	 * @param idNum 身份证
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("getNativeByIdNum/{idNum}")
	public @ResponseBody AjaxResult getNativeByIdNum(@PathVariable("idNum")String idNum, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Map<Long, Native> nativeData = (Map<Long, Native>) request.getSession().getServletContext().getAttribute(Constants.NATIVE_DATA);
			if(idNum.length() > 10) {
				idNum = IdNumUtil.getNativeCodeByIdNum(idNum,4);
				Long id = Long.valueOf(idNum);
				Native area = nativeData.get(id);
				if(area != null) {
					Native city = area.getParent();
					if(city != null) {
						city.getParent();
					}
					result.setSuccessful(true);
					result.setData(area);
				} else {
					result.setSuccessful(false);
					result.setMsg("未找到省市区");
				}
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 获取当前区域对象
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("getCurrentNative")
	public @ResponseBody AjaxResult getCurrentNative(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Long currentNativeCode = Long.valueOf(request.getServletContext().getAttribute(Constants.CURRENT_NATIVE).toString());
			Map<Long, Native> nativeData = (Map<Long, Native>) request.getServletContext().getAttribute(Constants.NATIVE_DATA);
			Native na = nativeData.get(currentNativeCode);
			Map<Long, List<Native>> nativeMap = (Map<Long, List<Native>>) request.getServletContext().getAttribute(Constants.NATIVE_MAP);
			List<Native> nativeList = nativeMap.get(currentNativeCode);
			na.setChildren(nativeList);
			result.setSuccessful(true);
			result.setData(na);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 获取任务等级
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("getTaskLevel")
	public @ResponseBody AjaxResult getTaskLevel(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<TaskLevel> levelList = (List<TaskLevel>) request.getServletContext().getAttribute(Constants.TASK_LEVEL);
			result.setSuccessful(true);
			result.setData(levelList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 获取任务种类
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("getTaskCatalog")
	public @ResponseBody AjaxResult getTaskCatalog(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<TaskCatalog> catalogList = (List<TaskCatalog>) request.getServletContext().getAttribute(Constants.TASK_CATALOG);
			result.setSuccessful(true);
			result.setData(catalogList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 获取任务类型
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("getTaskType")
	public @ResponseBody AjaxResult getTaskType(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User currentUser = arsRestUtil.getCurrentUser();
			if(currentUser == null){
				throw new ArsException("用户未登录!");
			}

			int platform = arsRestUtil.getCurrentUser().getPlatform();
			
			List<TaskType> typeList = (List<TaskType>) request.getServletContext().getAttribute(Constants.TASK_TYPE);
			
			List<TaskType> data = new ArrayList<TaskType>();
			for(TaskType type : typeList) {
				if(type.getPlatform() >= platform) {
					data.add(type);
				}
			}
			result.setSuccessful(true);
			result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 获取任务状态
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("getTaskStatus")
	public @ResponseBody AjaxResult getTaskStatus(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<TaskStatus> statusList = (List<TaskStatus>) request.getServletContext().getAttribute(Constants.TASK_STATUS);
			result.setSuccessful(true);
			result.setData(statusList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("login")
	public @ResponseBody AjaxResult login() {
		AjaxResult result = new AjaxResult();
		result.setCode("0000");
		result.setMsg("登录超时，请重新登录！");
		result.setSuccessful(false);
		return result;
	}
	
	@RequestMapping("refuse")
	public @ResponseBody AjaxResult refuse() {
		AjaxResult result = new AjaxResult();
		result.setCode("0001");
		result.setMsg("您没有授权访问，请联系管理员授权！！");
		result.setSuccessful(false);
		return result;
	}

	/**
	 * 在线预览
	 * @param request
	 * @return
	 */
	@RequestMapping("/previewOnLine")
	@ResponseBody
	public AjaxResult transferPreviewUrl(HttpServletRequest request,String paramUrl){
		AjaxResult result = new AjaxResult();
		Map<String,String> p = Maps.newHashMap();
        String path="";
        if (configUtils.isIntranet()) {
            path=configUtils.getOnlinePreviewUrl();
        }else {
            path=configUtils.getWebHost();
        }
		//String path=getContextUrl(request);
		if(StringUtil.isNotEmpty(paramUrl)) {
//			String url = "http://183.250.166.207:9029/ars-web/getResource.do?path=upload/2018-04-23/1524483395565.docx";

            String url=path+"/"+paramUrl;
            if(paramUrl.startsWith("http")){
                url = paramUrl;
            }
            url=url.replace("ars-web///ars-web","ars-web");
			p.put("fileUrl", url);
			String token = JwtUtil.createJWT(p);//加密生成token
			String previewUrl=previewFileUrl + "/preview?token=" + token;
			result.setSuccessful(true);
			result.setData(previewUrl);
			return result;
		}
		result.setSuccessful(false);
		return result;
	}


	private String getContextUrl(HttpServletRequest request){
		String ctxUrl=request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+request.getContextPath();
		return ctxUrl;
//
//		String strBackUrl = "http://" + request.getServerName() + ":"
//				+ request.getServerPort()
//				+ httpRequest.getContextPath()
//				+ httpRequest.getServletPath()
//				+ "?" + (httpRequest.getQueryString());
//		System.out.println("strBackUrl: " + strBackUrl);
	}
	
}
