package com.bcxin.ars.rest;

import com.bcxin.ars.dto.BankAccountExportDto;
import com.bcxin.ars.dto.page.BankAccountPageSearchDto;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.sys.BankAccountService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 银行账号信息控制器
 *
 * @author linqinglin
 * @Date 2020-05-13 14:37:13
 */
@Controller
@RequestMapping("bankAccount")
public class BankAccountController {

    Logger logger = LoggerFactory.getLogger(BankAccountController.class);

    @Autowired
    BankAccountService bankAccountService;


    @Autowired
   SecurityCertificateService SecurityCertificateService;

    @Autowired
    ArsUtil arsUtil;

    @RequestMapping("list/init")
    public ModelAndView listInit(BankAccountPageSearchDto searchDto){
        ModelAndView view = new ModelAndView();
        view.setViewName("bankAccount/list");
        view.addObject("record",searchDto);
        return view;
    }
    @RequestMapping("havePhoto")
    public ModelAndView photo(String id){
        ModelAndView view = new ModelAndView();
        view.setViewName("bankAccount/photo");
         if(StringUtil.isNotEmpty(id)){
             SecurityCertificate securityCertificate = SecurityCertificateService.findById(Long.valueOf(id));
             view.addObject("securityCertificate",securityCertificate);
         }
        return view;
    }


    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(BankAccountPageSearchDto dto, AjaxPageResponse<BankAccountExportDto> page){
        bankAccountService.searchForPage(dto,page);
        return page;
    }

}

