package com.bcxin.ars.rest;

import com.bcxin.ars.dto.appraise.AppraisePageResultDto;
import com.bcxin.ars.dto.appraise.AppraisePageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.util.AppraiseInterfaceUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.AppraiseConstants;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.commons.codec.binary.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.security.MessageDigest;
import java.util.Random;

/**
 * 好差评
 * @author linqinglin
 * @date 2020/10/15 0015 11:55
 */
@Controller
@RequestMapping("appraise")
public class AppraiseController {

    @Autowired
    private AppraiseInterfaceUtil appraiseInterfaceUtil;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    /**
     * 自然人 我的评价
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(AppraisePageSearchDto dto,HttpServletRequest request) {
        ModelAndView view = new ModelAndView("appraise/list");
        view.addObject("record",dto);
        return view;
    }

    /**
     * 企业法人 我的评价
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("frList/index")
    public ModelAndView frListIndex(AppraisePageSearchDto dto,HttpServletRequest request) {
        ModelAndView view = new ModelAndView("appraise/frList");
        view.addObject("record",dto);
        return view;
    }

    /**
     * 公安角色 评价管理
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("manageList/index")
    public ModelAndView manageListListIndex(AppraisePageSearchDto dto,HttpServletRequest request) {
        ModelAndView view = new ModelAndView("appraise/manageList");
        view.addObject("record",dto);
        return view;
    }

    /**
     * 评价分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxPageResponse searchForPage(AppraisePageSearchDto dto, AppraisePageResultDto page,HttpServletRequest request){//先获取单点处理类
        setSearchDto(dto,request);
        return appraiseInterfaceUtil.searchForPage(AppraiseConstants.URL_APPRAISE_LIST, dto, page);
    }

    /**
     * 待评价分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchUnAppraiseForPage")
    @ResponseBody
    public AjaxPageResponse searchUnAppraiseForPage(AppraisePageSearchDto dto, AppraisePageResultDto page, HttpServletRequest request){
        setSearchDto(dto,request);
        return appraiseInterfaceUtil.searchForPage(AppraiseConstants.URL_UNAPPRAISE_LIST, dto, page);
    }

    /**
     * 评价数据回流分页查询
     * 公安角色使用
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchManagePage")
    @ResponseBody
    public AjaxPageResponse searchManagePage(AppraisePageSearchDto dto, AppraisePageResultDto page,HttpServletRequest request){

        String time = DateUtil.getCurrentDate(DateUtil.FORMAT8);
        dto.setAppMark(AppraiseConstants.appMark);
        dto.setTime(time);
        dto.setToken(generate(AppraiseConstants.appMark+AppraiseConstants.appWord+time));
        return appraiseInterfaceUtil.searchForPage(AppraiseConstants.URL_NDFACTORS_LIST, dto, page);
    }

    private void setSearchDto(AppraisePageSearchDto dto,HttpServletRequest request){

        User currentUser = arsUtil.getCurrentUser();
        if(Constants.PLATFORM_NATURAL_PERSON == currentUser.getPlatform()){
            dto.setUserType(Constants.NO);
        }else if(Constants.PLATFORM_COMPANY == currentUser.getPlatform()){
            dto.setUserType(Constants.YES);
        }else if(Constants.PLATFORM_POLICE== currentUser.getPlatform()){
            dto.setUserType(Constants.YES);
        }
        dto.setSource(AppraiseConstants.source);
        if(request.getSession().getAttribute(Constants.SINGLELOGINBJ_UNIQUEID) != null) {
            dto.setUniqueId(request.getSession().getAttribute(Constants.SINGLELOGINBJ_UNIQUEID).toString());
            dto.setAccess_token(request.getSession().getAttribute(Constants.SINGLELOGINBJ_TOKEN).toString());
            dto.setToken(generate(configUtils.bj_zrr_client_secret+dto.getUniqueId()));
        }
    }

    public static String generate(String msg) {
        Random r = new Random();
        StringBuilder sb = new StringBuilder(16);
        sb.append(r.nextInt(99999999)).append(r.nextInt(99999999));
        int len = sb.length();
        if (len < 16) {
            for (int i = 0; i < 16 - len; i++) {
                sb.append("0");
            }
        }
        String salt = sb.toString();
        msg = md5Hex(msg + salt);
        char[] cs = new char[48];
        for (int i = 0; i < 48; i += 3) {
            cs[i] = msg.charAt(i / 3 * 2);
            char c = salt.charAt(i / 3);
            cs[i + 1] = c;
            cs[i + 2] = msg.charAt(i / 3 * 2 + 1);
        }
        return new String(cs);
    }
    private static String md5Hex(String src) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bs = md5.digest(src.getBytes());
            return new String(new Hex().encode(bs));
        } catch (Exception e) {
            return null;
        } }
}
